/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math.linear.FieldLUDecompositionImpl;
import org.apache.commons.math.linear.FieldMatrix;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class LUDecomposition
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST function) {
        try {
            if (function.size() == 2) {
                IAST list = (IAST)function.get(1);
                FieldMatrix<ExprFieldElement> matrix = Convert.list2Matrix(list);
                FieldLUDecompositionImpl<ExprFieldElement> lu = new FieldLUDecompositionImpl<ExprFieldElement>(matrix);
                FieldMatrix<ExprFieldElement> lMatrix = lu.getL();
                FieldMatrix<ExprFieldElement> uMatrix = lu.getU();
                int[] iArr = lu.getPivot();
                IAST iList = F.List();
                int i = 0;
                while (i < iArr.length) {
                    iList.add(F.integer(iArr[i] + 1));
                    ++i;
                }
                IAST result = F.List();
                IAST lMatrixAST = Convert.matrix2List(lMatrix);
                IAST uMatrixAST = Convert.matrix2List(uMatrix);
                result.add(lMatrixAST);
                result.add(uMatrixAST);
                result.add(iList);
                return result;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }
}

