/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.visit.AbstractVisitorInt;

public class LeafCount
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        return F.integer(LeafCount.leafCount((IExpr)ast.get(1)));
    }

    public static int leafCount(IExpr expr) {
        int leafCount = 0;
        leafCount = expr instanceof IAST ? expr.accept(new LeafCountVisitor(0)) : (expr.isAtom() ? 1 : 0);
        return leafCount;
    }

    public static class LeafCountVisitor
    extends AbstractVisitorInt {
        int fHeadOffset;

        public LeafCountVisitor() {
            this(1);
        }

        public LeafCountVisitor(int hOffset) {
            this.fHeadOffset = hOffset;
        }

        @Override
        public int visit(IFraction element) {
            return 3;
        }

        @Override
        public int visit(IComplex element) {
            return 3;
        }

        @Override
        public int visit(IComplexNum element) {
            return 3;
        }

        @Override
        public int visit(IAST list) {
            int sum = 0;
            int i = this.fHeadOffset;
            while (i < list.size()) {
                sum += ((IExpr)list.get(i)).accept(this);
                ++i;
            }
            return sum;
        }
    }
}

