/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class LetterQ
extends AbstractFunctionEvaluator
implements Predicate<IExpr> {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2 || !(functionList.get(1) instanceof IStringX)) {
            throw new WrongNumberOfArguments(functionList, 1, functionList.size() - 1);
        }
        return F.bool(this.apply((IExpr)functionList.get(1)));
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }

    public boolean apply(IExpr obj) {
        String str = obj.toString();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (!Character.isLetter(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

