/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IConstantHeaders;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Apart;

public class Limit
extends AbstractFunctionEvaluator
implements IConstantHeaders {
    private String[] RULES = new String[]{"Limit[x_^n_IntegerQ, x_Symbol->Infinity]=0/; Negative[n]", "Limit[x_^n_IntegerQ, x_Symbol->DirectedInfinity[-1]]=0/; Negative[n]", "Limit[(1+x_^(-1))^x_, x_Symbol->Infinity]=E", "Limit[(1-x_^(-1))^x_, x_Symbol->Infinity]=E^(-1)"};

    private static IExpr lHospitalesRule(IExpr numerator, IExpr denominator, ISymbol sym, IExpr lim, IAST rule) {
        EvalEngine engine = EvalEngine.get();
        int limit = engine.getRecursionLimit();
        if (limit > 0) {
            IExpr expr = F.eval(F.Times((IExpr)F.D(numerator, sym), (IExpr)F.Power((IExpr)F.D(denominator, sym), F.CN1)));
            return Limit.limit(expr, sym, lim, rule);
        }
        try {
            if (limit <= 0) {
                engine.setRecursionLimit(128);
            }
            IExpr expr = F.eval(F.Times((IExpr)F.D(numerator, sym), (IExpr)F.Power((IExpr)F.D(denominator, sym), F.CN1)));
            IExpr iExpr = Limit.limit(expr, sym, lim, rule);
            return iExpr;
        }
        catch (RecursionLimitExceeded rle) {
            engine.setRecursionLimit(limit);
        }
        finally {
            engine.setRecursionLimit(limit);
        }
        return null;
    }

    public static IExpr limit(IExpr expr, ISymbol sym, IExpr lim, IAST rule) {
        if (expr.isFree(sym)) {
            return expr;
        }
        if (expr.equals(sym)) {
            return lim;
        }
        if (expr instanceof IAST) {
            IAST arg1 = (IAST)expr;
            IExpr header = arg1.head();
            if (arg1.size() == 2 && (header.equals(F.Sin) || header.equals(F.Cos))) {
                return F.$(header, F.Limit((IExpr)arg1.get(1), rule));
            }
            if (header == F.Plus) {
                return Limit.mapLimit(arg1, rule);
            }
            if (header == F.Times) {
                IExpr denominator;
                IExpr[] parts = Apart.getFractionalPartsTimes(arg1, false);
                IExpr numerator = parts[0];
                IExpr temp = Limit.timesLimit(numerator, denominator = parts[1], sym, lim, rule);
                if (temp != null) {
                    return temp;
                }
                return Limit.mapLimit(arg1, rule);
            }
            if (arg1.isAST(F.Power, 3) && arg1.get(2) instanceof IInteger) {
                IInteger n = (IInteger)arg1.get(2);
                IExpr temp = F.eval(F.Limit((IExpr)arg1.get(1), rule));
                if (temp.equals(F.Indeterminate) || temp.isAST(F.Limit)) {
                    return null;
                }
                if (n.isPositive()) {
                    return F.Power(temp, n);
                }
                if (n.isNegative() && n.isEven()) {
                    return F.Power(temp, n);
                }
            }
        }
        return null;
    }

    private static IExpr mapLimit(IAST expr, IAST rule) {
        IAST resultList = expr.clone();
        int i = 1;
        while (i < resultList.size()) {
            resultList.set(i, F.Limit((IExpr)resultList.get(i), rule));
            ++i;
        }
        return resultList;
    }

    private static IExpr timesLimit(IExpr numerator, IExpr denominator, ISymbol sym, IExpr lim, IAST rule) {
        if (denominator.isOne() && numerator.isTimes()) {
            return Limit.mapLimit((IAST)numerator, rule);
        }
        if (!denominator.isNumber() || denominator.isZero()) {
            IExpr denValue = F.evalBlock(denominator, sym, lim);
            if (denValue.isZero()) {
                IExpr numValue = F.evalBlock(numerator, sym, lim);
                if (numValue.isZero()) {
                    return Limit.lHospitalesRule(numerator, denominator, sym, lim, rule);
                }
                return null;
            }
            if (F.CInfinity.equals(denValue)) {
                IExpr numValue = F.evalBlock(numerator, sym, lim);
                if (F.CInfinity.equals(numValue)) {
                    return Limit.lHospitalesRule(numerator, denominator, sym, lim, rule);
                }
                return null;
            }
            if (F.CNInfinity.equals(denValue)) {
                IExpr numValue = F.evalBlock(numerator, sym, lim);
                if (F.CNInfinity.equals(numValue)) {
                    return Limit.lHospitalesRule(numerator, denominator, sym, lim, rule);
                }
                return null;
            }
        }
        return F.Times((IExpr)F.Limit(numerator, rule), (IExpr)F.Power((IExpr)F.Limit(denominator, rule), F.CN1));
    }

    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 3 && ((IExpr)ast.get(2)).isRuleAST()) {
            return null;
        }
        IAST rule = (IAST)ast.get(2);
        if (!(rule.get(1) instanceof ISymbol)) {
            return null;
        }
        ISymbol sym = (ISymbol)rule.get(1);
        IExpr lim = null;
        if (!((IExpr)rule.get(2)).isFree(sym)) {
            return null;
        }
        lim = (IExpr)rule.get(2);
        return Limit.limit((IExpr)ast.get(1), sym, lim, rule);
    }

    @Override
    public String[] getRules() {
        return this.RULES;
    }
}

