/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.LinearConstraint;
import org.apache.commons.math.optimization.linear.LinearObjectiveFunction;
import org.apache.commons.math.optimization.linear.Relationship;
import org.apache.commons.math.optimization.linear.SimplexSolver;
import org.matheclipse.core.convert.Expr2Object;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;

public class LinearProgramming
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        return this.numericEval(ast);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IExpr numericEval(IAST ast) {
        IAST arg3;
        IAST arg2;
        ArrayList<LinearConstraint> constraints;
        LinearObjectiveFunction f;
        block14: {
            if (ast.size() < 4 || !((IExpr)ast.get(1)).isList() || !((IExpr)ast.get(2)).isList() || !((IExpr)ast.get(3)).isList()) return null;
            double[] arg1D = Expr2Object.toDoubleVector((IAST)ast.get(1));
            f = new LinearObjectiveFunction(arg1D, 0.0);
            constraints = new ArrayList<LinearConstraint>();
            arg2 = (IAST)ast.get(2);
            arg3 = (IAST)ast.get(3);
            if (arg2.size() == arg3.size()) break block14;
            return null;
        }
        try {
            int i = 1;
            while (i < arg2.size()) {
                double[] arg2D = Expr2Object.toDoubleVector((IAST)arg2.get(i));
                if (!((IExpr)arg2.get(i)).isList()) throw new WrongArgumentType(ast, (IExpr)ast.get(i), i, "Numeric vector expected!");
                if (((IExpr)arg3.get(i)).isList()) {
                    double[] arg3D = Expr2Object.toDoubleVector((IAST)arg3.get(i));
                    if (arg3D.length >= 2) {
                        double val = arg3D[1];
                        if (val == 0.0) {
                            constraints.add(new LinearConstraint(arg2D, Relationship.EQ, arg3D[0]));
                        } else if (val < 0.0) {
                            constraints.add(new LinearConstraint(arg2D, Relationship.LEQ, arg3D[0]));
                        } else if (val > 0.0) {
                            constraints.add(new LinearConstraint(arg2D, Relationship.GEQ, arg3D[0]));
                        }
                    } else if (arg3D.length == 1) {
                        constraints.add(new LinearConstraint(arg2D, Relationship.GEQ, arg3D[0]));
                    }
                } else {
                    if (!(arg3.get(i) instanceof ISignedNumber)) throw new WrongArgumentType(arg3, (IExpr)arg3.get(i), i, "Numeric vector or number expected!");
                    constraints.add(new LinearConstraint(arg2D, Relationship.GEQ, ((ISignedNumber)arg3.get(i)).doubleValue()));
                }
                ++i;
            }
            SimplexSolver solver = new SimplexSolver();
            RealPointValuePair solution = solver.optimize(f, constraints, GoalType.MINIMIZE, true);
            double[] values = solution.getPointRef();
            return F.List(values);
        }
        catch (OptimizationException oe) {
            throw MathRuntimeException.createInternalError(oe);
        }
    }
}

