/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ManhattanDistance
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        int dim2;
        if (ast.size() != 3) {
            throw new WrongNumberOfArguments(ast, 2, ast.size() - 1);
        }
        IExpr arg1 = (IExpr)ast.get(1);
        IExpr arg2 = (IExpr)ast.get(2);
        int dim1 = arg1.isVector();
        if (dim1 > -1 && dim1 == (dim2 = arg2.isVector())) {
            if (dim1 == 0) {
                return F.C0;
            }
            IAST a1 = (IAST)arg1;
            IAST a2 = (IAST)arg2;
            IAST plusAST = F.Plus();
            int i = 1;
            while (i < a1.size()) {
                plusAST.add(F.Abs(F.Subtract((IExpr)a1.get(i), (IExpr)a2.get(i))));
                ++i;
            }
            return plusAST;
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

