/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math.linear.BlockFieldMatrix;
import org.apache.commons.math.linear.FieldMatrix;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.exception.NonNegativeIntegerExpected;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ExprField;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class MatrixPower
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        int p;
        FieldMatrix<ExprFieldElement> matrix;
        block11: {
            if (ast.size() != 3) {
                return null;
            }
            matrix = Convert.list2Matrix((IAST)ast.get(1));
            p = Validate.checkIntType(ast, 2, Integer.MIN_VALUE);
            if (p >= 0) break block11;
            return null;
        }
        try {
            if (p == 1) {
                ((IAST)ast.get(1)).addEvalFlags(32);
                return (IExpr)ast.get(1);
            }
            if (p == 0) {
                BlockFieldMatrix<ExprFieldElement> resultMatrix = new BlockFieldMatrix<ExprFieldElement>(ExprField.CONST, matrix.getRowDimension(), matrix.getColumnDimension());
                int min = matrix.getRowDimension();
                if (min > matrix.getColumnDimension()) {
                    min = matrix.getColumnDimension();
                }
                int i = 0;
                while (i < min) {
                    resultMatrix.setEntry(i, i, ExprField.CONST.getOne());
                    ++i;
                }
                return Convert.matrix2List(resultMatrix);
            }
            FieldMatrix<ExprFieldElement> resultMatrix = matrix;
            int i = 1;
            while (i < p) {
                resultMatrix = resultMatrix.multiply(matrix);
                ++i;
            }
            return Convert.matrix2List(resultMatrix);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
            throw new NonNegativeIntegerExpected(ast, 2);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return null;
    }
}

