/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.BigInteger;
import java.util.List;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Factorial;

public class Multinomial
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() >= 3) {
            int i = 1;
            while (i < ast.size()) {
                if (!(ast.get(i) instanceof IInteger)) {
                    return null;
                }
                if (((IInteger)ast.get(i)).isNegative()) {
                    return null;
                }
                ++i;
            }
            return F.integer(Multinomial.multinomial(ast));
        }
        return null;
    }

    public static BigInteger multinomial(List<IExpr> ast) {
        BigInteger n = BigInteger.ZERO;
        BigInteger denom = BigInteger.ONE;
        int i = 1;
        while (i < ast.size()) {
            BigInteger k = ((IInteger)ast.get(i)).getBigNumerator();
            n = n.add(k);
            denom = denom.multiply(Factorial.factorial(k));
            ++i;
        }
        return Factorial.factorial(n).divide(denom);
    }

    public static BigInteger multinomial(int[] indices, int n) {
        BigInteger bn = BigInteger.valueOf(n);
        BigInteger denom = BigInteger.ONE;
        int i = 0;
        while (i < indices.length) {
            if (indices[i] != 0) {
                denom = denom.multiply(Factorial.factorial(BigInteger.valueOf(indices[i])));
            }
            ++i;
        }
        return Factorial.factorial(bn).divide(denom);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

