/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.integration.LegendreGaussIntegrator;
import org.apache.commons.math.analysis.integration.RombergIntegrator;
import org.apache.commons.math.analysis.integration.SimpsonIntegrator;
import org.apache.commons.math.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IConstantHeaders;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class NIntegrate
extends AbstractFunctionEvaluator
implements IConstantHeaders {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() == 3 || ast.size() == 4) {
            String method = "Trapezoid";
            if (ast.size() == 4 && ast.get(3) instanceof ISymbol) {
                method = ((IExpr)ast.get(3)).toString();
            }
            if (((IExpr)ast.get(2)).isList()) {
                IAST list = (IAST)ast.get(2);
                IExpr function = (IExpr)ast.get(1);
                if (list.size() == 4 && list.get(1) instanceof ISymbol && list.get(2) instanceof ISignedNumber && list.get(3) instanceof ISignedNumber) {
                    if (function.isAST("Equal", 3)) {
                        function = F.Plus((IExpr)((IAST)function).get(1), (IExpr)F.Times((IExpr)F.CN1, (IExpr)((IAST)function).get(2)));
                    }
                    try {
                        return Num.valueOf(this.integrate(method, list, function));
                    }
                    catch (ConvergenceException e) {
                        e.printStackTrace();
                    }
                    catch (FunctionEvaluationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private double integrate(String method, IAST list, IExpr function) throws ConvergenceException, FunctionEvaluationException {
        ISymbol xVar = (ISymbol)list.get(1);
        ISignedNumber min = (ISignedNumber)list.get(2);
        ISignedNumber max = (ISignedNumber)list.get(3);
        EvalEngine engine = EvalEngine.get();
        function = F.eval(function);
        UnaryNumerical f = new UnaryNumerical(function, xVar, engine);
        UnivariateRealIntegratorImpl integrator = new TrapezoidIntegrator();
        if (method.equals("Simpson")) {
            integrator = new SimpsonIntegrator();
        } else if (method.equals("LegendreGauss")) {
            integrator = new LegendreGaussIntegrator(3, 64);
        } else if (method.equals("Romberg")) {
            integrator = new RombergIntegrator();
        }
        return integrator.integrate(f, min.doubleValue(), max.doubleValue());
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(32);
    }
}

