/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Norm
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            throw new WrongNumberOfArguments(functionList, 1, functionList.size() - 1);
        }
        IExpr arg = (IExpr)functionList.get(1);
        if (arg instanceof INumber) {
            return ((INumber)arg).eabs();
        }
        int dim = arg.isVector();
        if (dim > -1) {
            IAST plusAST = F.Plus();
            for (IExpr expr : ((IAST)arg).range(1)) {
                plusAST.add(F.Sqr(F.Abs(expr)));
            }
            return F.Sqrt(plusAST);
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

