/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class NumberQ
extends AbstractFunctionEvaluator
implements Predicate<IExpr> {
    public static final NumberQ CONST = new NumberQ();

    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            throw new WrongNumberOfArguments(functionList, 1, functionList.size() - 1);
        }
        return F.bool(((IExpr)functionList.get(1)).isNumber());
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }

    public boolean apply(IExpr obj) {
        return obj.isNumber();
    }
}

