/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.AbstractVisitorBoolean;
import org.matheclipse.parser.client.SyntaxError;

public class NumericQ
extends AbstractFunctionEvaluator
implements Predicate<IExpr> {
    public static final NumericQ CONST = new NumericQ();

    public boolean apply(IExpr arg0) {
        return arg0.accept(new NumericQVisitor());
    }

    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            throw new WrongNumberOfArguments(functionList, 1, functionList.size() - 1);
        }
        return F.bool(this.apply((IExpr)functionList.get(1)));
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(96);
    }

    public static class NumericQVisitor
    extends AbstractVisitorBoolean {
        @Override
        public boolean visit(IAST list) {
            ISymbol symbol = list.topHead();
            if ((symbol.getAttributes() & 0x400) == 1024) {
                int i = 1;
                while (i < list.size()) {
                    if (!((IExpr)list.get(i)).accept(this)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean visit(IComplex element) {
            return true;
        }

        @Override
        public boolean visit(IComplexNum element) {
            return true;
        }

        @Override
        public boolean visit(IFraction element) {
            return true;
        }

        @Override
        public boolean visit(IInteger element) {
            return true;
        }

        @Override
        public boolean visit(INum element) {
            return true;
        }

        @Override
        public boolean visit(ISymbol symbol) {
            return (symbol.getAttributes() & 2) == 2;
        }
    }
}

