/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import org.matheclipse.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.output.StringBufferWriter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class Package
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (!(ast.size() == 4 && ast.get(1) instanceof IStringX && ((IExpr)ast.get(2)).isList() && ((IExpr)ast.get(3)).isList())) {
            throw new WrongNumberOfArguments(ast, 1, ast.size() - 1);
        }
        if (Config.SERVER_MODE) {
            throw new RuleCreationError(null);
        }
        IAST symbols = (IAST)ast.get(2);
        IAST list = (IAST)ast.get(3);
        Package.evalPackage(symbols, list);
        return F.Null;
    }

    public static void evalPackage(IAST publicSymbols, IAST list) {
        HashMap<ISymbol, ISymbol> convertedSymbolMap = new HashMap<ISymbol, ISymbol>();
        HashSet<ISymbol> publicSymbolSet = new HashSet<ISymbol>();
        int i = 1;
        while (i < publicSymbols.size()) {
            IExpr expr = (IExpr)publicSymbols.get(i);
            if (expr instanceof ISymbol) {
                publicSymbolSet.add((ISymbol)expr);
                ISymbol toSymbol = F.predefinedSymbol(((ISymbol)expr).toString());
                convertedSymbolMap.put((ISymbol)expr, toSymbol);
            }
            ++i;
        }
        i = 1;
        while (i < list.size()) {
            if (list.get(i) instanceof IAST) {
                Package.determineRuleHead((IAST)list.get(i), publicSymbolSet, convertedSymbolMap);
            }
            ++i;
        }
        IAST resultList = F.List();
        int i2 = 1;
        while (i2 < list.size()) {
            resultList.add(Package.convertSymbolsInExpr((IExpr)list.get(i2), convertedSymbolMap));
            ++i2;
        }
        EvalEngine engine = EvalEngine.get();
        try {
            engine.setPackageMode(true);
            int i3 = 1;
            while (i3 < resultList.size()) {
                EvalEngine.eval((IExpr)resultList.get(i3));
                ++i3;
            }
        }
        finally {
            engine.setPackageMode(false);
        }
    }

    private static void determineRuleHead(IAST rule, HashSet<ISymbol> unprotectedSymbolSet, HashMap<ISymbol, ISymbol> convertedSymbolMap) {
        if (rule.size() > 1 && (rule.head().equals(F.Set) || rule.head().equals(F.SetDelayed))) {
            ISymbol toSymbol;
            ISymbol lhsHead = null;
            if (rule.get(1) instanceof IAST) {
                lhsHead = ((IAST)rule.get(1)).topHead();
            } else if (rule.get(1) instanceof ISymbol) {
                lhsHead = (ISymbol)rule.get(1);
            }
            if (lhsHead != null && !unprotectedSymbolSet.contains(lhsHead) && (toSymbol = convertedSymbolMap.get(lhsHead)) == null) {
                toSymbol = F.predefinedSymbol("@" + EvalEngine.getNextCounter() + lhsHead.toString());
                convertedSymbolMap.put(lhsHead, toSymbol);
            }
        }
    }

    private static IExpr convertSymbolsInExpr(IExpr expr, HashMap<ISymbol, ISymbol> convertedSymbols) {
        ISymbol toSymbol;
        IExpr result = expr;
        if (expr instanceof IAST) {
            result = Package.convertSymbolsInList((IAST)expr, convertedSymbols);
        } else if (expr instanceof ISymbol && (toSymbol = convertedSymbols.get((ISymbol)expr)) != null) {
            result = toSymbol;
        }
        return result;
    }

    private static IAST convertSymbolsInList(IAST ast, HashMap<ISymbol, ISymbol> convertedSymbols) {
        IAST result = ast.clone();
        int i = 0;
        while (i < result.size()) {
            ISymbol toSymbol;
            IExpr expr = (IExpr)result.get(i);
            if (expr instanceof IAST) {
                result.set(i, Package.convertSymbolsInList((IAST)expr, convertedSymbols));
            } else if (expr instanceof ISymbol && (toSymbol = convertedSymbols.get((ISymbol)expr)) != null) {
                result.set(i, toSymbol);
            }
            ++i;
        }
        return result;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }

    public static void loadPackage(EvalEngine engine, Reader is) {
        String record = null;
        StringBufferWriter buf = new StringBufferWriter();
        BufferedReader r = new BufferedReader(is);
        try {
            try {
                StringBuilder builder = new StringBuilder(2048);
                while ((record = r.readLine()) != null) {
                    builder.append(record);
                    builder.append('\n');
                }
                buf.setIgnoreNewLine(true);
                IExpr parsedExpression = engine.parse(builder.toString());
                if (parsedExpression != null && parsedExpression instanceof IAST) {
                    IAST ast = (IAST)parsedExpression;
                    if (!(ast.size() == 4 && ast.get(1) instanceof IStringX && ((IExpr)ast.get(2)).isList() && ((IExpr)ast.get(3)).isList())) {
                        throw new WrongNumberOfArguments(ast, 3, ast.size() - 1);
                    }
                    IAST symbols = (IAST)ast.get(2);
                    IAST list = (IAST)ast.get(3);
                    Package.evalPackage(symbols, list);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    buf.close();
                    r.close();
                    is.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                buf.close();
                r.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

