/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class Part
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() == 3 && ast.get(1) instanceof IAST) {
            IAST arg0 = (IAST)ast.get(1);
            IExpr arg1 = (IExpr)ast.get(2);
            if (arg1 instanceof IInteger) {
                try {
                    int indx = Validate.checkIntType(ast, 2);
                    return this.getIndex(arg0, indx);
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
            if (arg1.isList()) {
                IAST lst = (IAST)arg1;
                IAST result = F.ast(F.List);
                int i = 1;
                while (i < lst.size()) {
                    IExpr expr = (IExpr)lst.get(i);
                    if (expr instanceof IInteger) {
                        IExpr ires = null;
                        int indx = Validate.checkIntType(lst, i);
                        ires = this.getIndex(arg0, indx);
                        if (ires == null) {
                            return null;
                        }
                        result.add(ires);
                    } else {
                        IAST part = F.ast(F.Part);
                        part.add(expr);
                        result.add(part);
                    }
                    ++i;
                }
                return result;
            }
        }
        return null;
    }

    IExpr getIndex(IAST ast, int indx) {
        Validate.checkRange(ast, 0, ast.size());
        if (indx < 0 || indx >= ast.size()) {
            throw new IndexOutOfBoundsException("index: " + indx);
        }
        return (IExpr)ast.get(indx);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

