/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.basic.Alloc;
import org.matheclipse.basic.Config;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.swing.plot.PlotFrame;
import org.matheclipse.swing.plot.Plotter;

public class Plot
implements IFunctionEvaluator {
    private static final int N = 100;

    @Override
    public IExpr evaluate(IAST ast) {
        IAST lst;
        if (Config.SWING_PLOT_FRAME) {
            Plotter plotter = Plotter.getPlotter();
            PlotFrame frame = new PlotFrame(plotter, ast);
            frame.invokeLater();
            return F.Null;
        }
        EvalEngine engine = EvalEngine.get();
        if (ast.size() >= 3 && ast.size() <= 4 && ((IExpr)ast.get(2)).isList() && (lst = (IAST)ast.get(2)).size() == 4) {
            IExpr temp;
            IAST lsty;
            IExpr a = engine.evaluate(F.N((IExpr)lst.get(2)));
            IExpr b = engine.evaluate(F.N((IExpr)lst.get(3)));
            if (!(a instanceof INum) || !(b instanceof INum)) {
                return null;
            }
            double ad = ((INum)a).getRealPart();
            double bd = ((INum)b).getRealPart();
            if (bd <= ad) {
                return null;
            }
            double y0d = 0.0;
            double y1d = 0.0;
            if (ast.size() == 4 && ((IExpr)ast.get(3)).isList() && (lsty = (IAST)ast.get(3)).size() == 3) {
                IExpr y0 = engine.evaluate(F.N((IExpr)lsty.get(1)));
                IExpr y1 = engine.evaluate(F.N((IExpr)lsty.get(2)));
                if (y0 instanceof INum && y1 instanceof INum) {
                    y0d = ((INum)y0).getRealPart();
                    y1d = ((INum)y1).getRealPart();
                }
            }
            IAST graphics = F.Graphics();
            IAST line = F.Line();
            if (((IExpr)ast.get(1)).isList()) {
                IAST list = (IAST)ast.get(1);
                IAST primitives = F.List();
                int i = 1;
                while (i < list.size()) {
                    temp = this.plotLine(ad, bd, y0d, y1d, (IExpr)list.get(2), (ISymbol)lst.get(1), engine);
                    if (temp != null) {
                        line.add(temp);
                        primitives.add(line);
                    }
                    if (i < list.size() - 1) {
                        line = F.Line();
                    }
                    ++i;
                }
                graphics.add(primitives);
            } else {
                temp = this.plotLine(ad, bd, y0d, y1d, (IExpr)ast.get(1), (ISymbol)lst.get(1), engine);
                if (temp != null) {
                    line.add(temp);
                    graphics.add(line);
                }
            }
            IExpr[] options = new IExpr[]{F.Rule(F.PlotRange, F.Automatic), F.Rule(F.AxesStyle, F.Automatic), F.Rule(F.AxesOrigin, F.List((IExpr)F.C0, (IExpr)F.C0)), F.Rule(F.Axes, F.True), F.Rule(F.Background, F.White)};
            graphics.add(F.ast(options, F.List));
            return F.Show(graphics);
        }
        return F.Null;
    }

    public IExpr plotLine(double ad, double bd, double y0d, double y1d, IExpr function, ISymbol xVar, EvalEngine engine) {
        double step = (bd - ad) / 100.0;
        UnaryNumerical hun = new UnaryNumerical(function, xVar, engine);
        Alloc alloc = Alloc.get();
        double[][] data = alloc.matrixCheck(2, 101);
        double x = ad;
        int i = 0;
        while (i < 101) {
            double y = hun.value(x);
            if (y0d != 0.0 || y1d != 0.0) {
                if (y >= y0d && y <= y1d) {
                    data[0][i] = x;
                    data[1][i] = y;
                } else if (y < y0d) {
                    data[0][i] = x;
                    data[1][i] = y0d;
                } else {
                    data[0][i] = x;
                    data[1][i] = y1d;
                }
            } else {
                data[0][i] = x;
                data[1][i] = y;
            }
            x += step;
            ++i;
        }
        return Convert.doubleToExprTranspose(data);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(96);
    }
}

