/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import javax.swing.JOptionPane;
import org.matheclipse.basic.Alloc;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.BinaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class Plot3D
implements IFunctionEvaluator {
    private static final int NUMBER_OF_DIVISIONS = 21;

    @Override
    public IExpr evaluate(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        if (ast.size() >= 4 && ((IExpr)ast.get(2)).isList() && ((IExpr)ast.get(3)).isList()) {
            IAST graphics = F.SurfaceGraphics();
            IAST lst1 = (IAST)ast.get(2);
            IAST lst2 = (IAST)ast.get(3);
            if (lst1.size() == 4 && lst2.size() == 4) {
                Options hOptions = new Options(F.Plot3D, ast, 4);
                IExpr a = engine.evaluate(F.N((IExpr)lst1.get(2)));
                IExpr b = engine.evaluate(F.N((IExpr)lst1.get(3)));
                IExpr c = engine.evaluate(F.N((IExpr)lst2.get(2)));
                IExpr d = engine.evaluate(F.N((IExpr)lst2.get(3)));
                if (!(a instanceof INum && b instanceof INum && c instanceof INum && d instanceof INum)) {
                    return null;
                }
                double ad = ((INum)a).getRealPart();
                double bd = ((INum)b).getRealPart();
                double cd = ((INum)c).getRealPart();
                double dd = ((INum)d).getRealPart();
                if (bd <= ad) {
                    return null;
                }
                if (dd <= cd) {
                    return null;
                }
                IExpr temp = this.plotArray(ad, bd, cd, dd, (IExpr)ast.get(1), (ISymbol)lst1.get(1), (ISymbol)lst2.get(1), engine);
                if (temp != null) {
                    graphics.add(temp);
                }
                IAST options = F.List();
                options.add(F.Rule(F.PlotRange, F.Automatic));
                options.add(F.Rule(F.MeshRange, F.List((IExpr)F.List(a, b), (IExpr)F.List(c, d))));
                graphics.add(options);
                return F.Show(graphics);
            }
        }
        return F.Null;
    }

    public IExpr plotArray(double ad, double bd, double cd, double dd, IExpr function, ISymbol xVar, ISymbol yVar, EvalEngine session) {
        double xStep = (bd - ad) / 21.0;
        double yStep = (dd - cd) / 21.0;
        BinaryNumerical hbn = new BinaryNumerical(function, xVar, yVar);
        Alloc alloc = Alloc.get();
        double[][] data = alloc.matrixCheck(22, 22);
        double x = ad;
        int i = 0;
        while (i < 21) {
            double y = cd;
            int j = 0;
            while (j < 21) {
                double z;
                try {
                    z = hbn.value(x, y);
                }
                catch (Throwable se) {
                    z = Double.NaN;
                }
                data[i][j] = z;
                y += yStep;
                ++j;
            }
            x += xStep;
            ++i;
        }
        return Object2Expr.CONST.convert(data);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(96);
    }

    static class NoJ3DRunnable
    implements Runnable {
        NoJ3DRunnable() {
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(null, "MatheEclipse requires the Java3D extension to be installed to plot 3D graphs.\nWindows users can download Java3D from java.com.\nMacintosh users can download Java3D from Apple's web site.\nLinux/x86 users can download Java3D from Blackdown.org", "MathEclipse: Java3D not installed", 0);
        }
    }
}

