/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractArgMultiple;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.HashedOrderlessMatcher;

public class Plus
extends AbstractArgMultiple
implements INumeric {
    private static HashedOrderlessMatcher ORDERLESS_MATCHER = new HashedOrderlessMatcher(true);

    @Override
    public HashedOrderlessMatcher getHashRuleMap() {
        return ORDERLESS_MATCHER;
    }

    @Override
    public IExpr e2ComArg(IComplex c0, IComplex c1) {
        return c0.add(c1);
    }

    @Override
    public IExpr e2DblArg(INum d0, INum d1) {
        return d0.add(d1);
    }

    @Override
    public IExpr e2DblComArg(IComplexNum d0, IComplexNum d1) {
        return d0.add(d1);
    }

    @Override
    public IExpr e2FraArg(IFraction f0, IFraction f1) {
        return f0.add(f1);
    }

    @Override
    public IExpr e2IntArg(IInteger i0, IInteger i1) {
        return i0.add(i1);
    }

    @Override
    public IExpr e2ObjArg(IExpr o0, IExpr o1) {
        IAST f1;
        IExpr temp = null;
        EvalEngine ee = EvalEngine.get();
        if (ee.isNumericMode()) {
            if (o0.equals(F.CD0)) {
                return o1;
            }
            if (o1.equals(F.CD0)) {
                return o0;
            }
        }
        if (o0.equals(F.C0)) {
            return o1;
        }
        if (o1.equals(F.C0)) {
            return o0;
        }
        if (o0.equals(F.Indeterminate) || o1.equals(F.Indeterminate)) {
            return F.Indeterminate;
        }
        if (o0.isAST(F.DirectedInfinity, 2)) {
            temp = this.eInfinity(o0, o1);
        } else if (o1.isAST(F.DirectedInfinity, 2)) {
            temp = this.eInfinity(o1, o0);
        }
        if (temp != null) {
            return temp;
        }
        if (o0.equals(o1)) {
            return F.Times((IExpr)F.C2, o0);
        }
        if (o0.isAST(F.Times) && ((IAST)o0).size() > 2) {
            AST f12;
            AST f0 = (AST)o0;
            if (f0.get(1) instanceof INumber) {
                if (f0.size() == 3 && ((IExpr)f0.get(2)).equals(o1)) {
                    return F.Times((IExpr)F.Plus((IExpr)F.C1, (IExpr)f0.get(1)), o1);
                }
                if (o1.isAST(F.Times) && ((IAST)o1).size() > 2) {
                    AST f13 = (AST)o1;
                    if (f13.get(1) instanceof INumber) {
                        if (f0.equalsFromPosition(1, f13, 1)) {
                            IAST result = F.ast(f0, F.Times, true, 2, f0.size());
                            return F.Times((IExpr)F.Plus((IExpr)f0.get(1), (IExpr)f13.get(1)), (IExpr)result);
                        }
                    } else if (f0.equalsFromPosition(1, f13, 0)) {
                        IAST result = F.ast(f0, F.Times, true, 2, f0.size());
                        return F.Times((IExpr)F.Plus((IExpr)F.C1, (IExpr)f0.get(1)), (IExpr)result);
                    }
                }
            } else if (o1.isAST(F.Times) && ((IAST)o1).size() > 2 && (f12 = (AST)o1).get(1) instanceof INumber && f0.equalsFromPosition(0, f12, 1)) {
                IAST result = F.ast(f12, F.Times, true, 2, f12.size());
                return F.Times((IExpr)F.Plus((IExpr)F.C1, (IExpr)f12.get(1)), (IExpr)result);
            }
        }
        if (o1.isAST(F.Times) && ((IAST)o1).size() > 2 && ((IAST)o1).get(1) instanceof INumber && (f1 = (IAST)o1).size() == 3 && ((IExpr)f1.get(2)).equals(o0)) {
            return F.Times((IExpr)F.Plus((IExpr)F.C1, (IExpr)f1.get(1)), o0);
        }
        return null;
    }

    private IExpr eInfinity(IExpr inf, IExpr o1) {
        if (inf.equals(F.CInfinity)) {
            if (o1.equals(F.CInfinity)) {
                return F.CInfinity;
            }
            if (o1.equals(F.CNInfinity)) {
                EvalEngine.get().getOutPrintStream().println("Indeterminate expression Infinity-Infinity");
                return F.Indeterminate;
            }
            if (o1 instanceof ISignedNumber) {
                return F.CInfinity;
            }
        } else if (inf.equals(F.CNInfinity)) {
            if (o1.equals(F.CInfinity)) {
                EvalEngine.get().getOutPrintStream().println("Indeterminate expression Infinity-Infinity");
                return F.Indeterminate;
            }
            if (o1.equals(F.CNInfinity)) {
                return F.CNInfinity;
            }
            if (o1 instanceof ISignedNumber) {
                return F.CNInfinity;
            }
        }
        return null;
    }

    @Override
    public IExpr eComIntArg(IComplex c0, IInteger i1) {
        return c0.add(F.complex(i1, F.C0));
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1165);
        ORDERLESS_MATCHER.setUpHashRule("Sin[x_]^2", "Cos[x_]^2", "1");
        ORDERLESS_MATCHER.setUpHashRule("ArcSin[x_]", "ArcCos[x_]", "Pi/2");
        ORDERLESS_MATCHER.setUpHashRule("ArcTan[x_]", "ArcCot[x_]", "Pi/2");
        ORDERLESS_MATCHER.setUpHashRule("ArcTan[x_]", "ArcTan[y_]", "Pi/2", "Positive[x]&&(y==1/x)");
        ORDERLESS_MATCHER.setUpHashRule("-ArcTan[x_]", "-ArcTan[y_]", "-Pi/2", "Positive[x]&&(y==1/x)");
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        double result = 0.0;
        int i = top - size + 1;
        while (i < top + 1) {
            result += stack[i];
            ++i;
        }
        return result;
    }
}

