/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.GenPolynomial;
import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class PolynomialExtendedGCD
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST lst) {
        if (lst.size() != 4 && lst.size() != 5 && !(lst.get(3) instanceof ISymbol)) {
            return null;
        }
        ISymbol x = (ISymbol)lst.get(3);
        IExpr expr1 = F.evalExpandAll((IExpr)lst.get(1));
        IExpr expr2 = F.evalExpandAll((IExpr)lst.get(2));
        ExprVariables eVar = new ExprVariables(expr1);
        if (!eVar.isSize(1) || !eVar.contains(x)) {
            return null;
        }
        eVar = new ExprVariables(expr2);
        if (!eVar.isSize(1) || !eVar.contains(x)) {
            return null;
        }
        ASTRange r = new ASTRange(eVar.getVarList(), 1);
        if (lst.size() == 5) {
            List<IExpr> varList = r.toList();
            Options options = new Options(lst.topHead(), lst, 4);
            IExpr option = options.getOption("Modulus");
            if (option != null && option instanceof IInteger) {
                try {
                    BigInteger value = ((IInteger)option).getBigNumerator();
                    int intValue = ((IInteger)option).toInt();
                    ModIntegerRing modIntegerRing = new ModIntegerRing(intValue, value.isProbablePrime(32));
                    JASConvert<ModInteger> jas = new JASConvert<ModInteger>(varList, modIntegerRing);
                    GenPolynomial<ModInteger> poly1 = jas.expr2Poly(expr1);
                    GenPolynomial<ModInteger> poly2 = jas.expr2Poly(expr2);
                    GenPolynomial<ModInteger>[] result = poly1.egcd(poly2);
                    IAST list = F.List();
                    list.add(jas.modIntegerPoly2Expr(result[0]));
                    IAST subList = F.List();
                    subList.add(jas.modIntegerPoly2Expr(result[1]));
                    subList.add(jas.modIntegerPoly2Expr(result[2]));
                    list.add(subList);
                    return list;
                }
                catch (ArithmeticException ae) {
                    return null;
                }
            }
        }
        try {
            JASConvert<BigRational> jas = new JASConvert<BigRational>(r.toList(), BigRational.ZERO);
            GenPolynomial<BigRational> poly1 = jas.expr2Poly(expr1);
            GenPolynomial<BigRational> poly2 = jas.expr2Poly(expr2);
            GenPolynomial<BigRational>[] result = poly1.egcd(poly2);
            IAST list = F.List();
            list.add(jas.rationalPoly2Expr(result[0]));
            IAST subList = F.List();
            subList.add(jas.rationalPoly2Expr(result[1]));
            subList.add(jas.rationalPoly2Expr(result[2]));
            list.add(subList);
            return list;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

