/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.GenPolynomial;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class PolynomialGCD
extends AbstractFunctionEvaluator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IExpr evaluate(IAST lst) {
        Options options;
        IExpr option;
        if (lst.size() < 3) {
            return null;
        }
        ExprVariables eVar = new ExprVariables((IExpr)lst.get(1));
        if (!eVar.isSize(1)) {
            return null;
        }
        ASTRange r = new ASTRange(eVar.getVarList(), 1);
        IExpr expr = F.evalExpandAll((IExpr)lst.get(1));
        if (lst.size() > 3 && (option = (options = new Options(lst.topHead(), lst, lst.size() - 1)).getOption("Modulus")) != null && option instanceof IInteger) {
            try {
                BigInteger value = ((IInteger)option).getBigNumerator();
                int intValue = ((IInteger)option).toInt();
                ModIntegerRing modIntegerRing = new ModIntegerRing(intValue, value.isProbablePrime(32));
                JASConvert<ModInteger> jas = new JASConvert<ModInteger>(r.toList(), modIntegerRing);
                GenPolynomial<ModInteger> poly = jas.expr2Poly(expr);
                int i = 2;
                while (true) {
                    if (i >= lst.size() - 1) {
                        return jas.modIntegerPoly2Expr(poly);
                    }
                    eVar = new ExprVariables((IExpr)lst.get(i));
                    if (!eVar.isSize(1)) {
                        return null;
                    }
                    expr = F.evalExpandAll((IExpr)lst.get(i));
                    GenPolynomial<ModInteger> temp = jas.expr2Poly(expr);
                    poly = poly.gcd(temp);
                    ++i;
                }
            }
            catch (ArithmeticException ae) {
                return null;
            }
        }
        try {
            JASConvert<BigRational> jas = new JASConvert<BigRational>(r.toList(), BigRational.ZERO);
            GenPolynomial<BigRational> poly = jas.expr2Poly(expr);
            int i = 2;
            while (true) {
                if (i >= lst.size()) {
                    return jas.rationalPoly2Expr(poly);
                }
                eVar = new ExprVariables((IExpr)lst.get(i));
                if (!eVar.isSize(1)) {
                    return null;
                }
                expr = F.evalExpandAll((IExpr)lst.get(i));
                GenPolynomial<BigRational> temp = jas.expr2Poly(expr);
                poly = poly.gcd(temp);
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

