/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.generic.interfaces.BiPredicate;

public class PolynomialQ
extends AbstractFunctionEvaluator
implements BiPredicate<IExpr> {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 3) {
            throw new WrongNumberOfArguments(ast, 2, ast.size() - 1);
        }
        IAST list = ((IExpr)ast.get(2)).isList() ? (IAST)ast.get(2) : F.List((IExpr)ast.get(2));
        return F.bool(PolynomialQ.polynomialQ((IExpr)ast.get(1), list));
    }

    public static boolean polynomialQ(IExpr polnomialExpr, IAST variables) {
        try {
            IExpr expr = F.evalExpandAll(polnomialExpr);
            ASTRange r = new ASTRange(variables, 1);
            JASConvert<BigRational> jas = new JASConvert<BigRational>(r.toList(), BigRational.ZERO);
            return jas.expr2Poly(expr) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
    }

    @Override
    public boolean apply(IExpr firstArg, IExpr secondArg) {
        IAST list = secondArg.isList() ? (IAST)secondArg : F.List(secondArg);
        return PolynomialQ.polynomialQ(firstArg, list);
    }
}

