/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.DivisionByZero;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Power
extends AbstractArg2
implements INumeric {
    @Override
    public IExpr e2DblComArg(IComplexNum c0, IComplexNum c1) {
        return c0.pow(c1);
    }

    @Override
    public IExpr e2ComArg(IComplex c0, IComplex c1) {
        return null;
    }

    @Override
    public IExpr e2DblArg(INum d0, INum d1) {
        if (d0.isNegative()) {
            return F.complexNum(d0.doubleValue()).pow(F.complexNum(d1.doubleValue()));
        }
        return d0.pow(d1);
    }

    @Override
    public IExpr e2IntArg(IInteger i0, IInteger i1) {
        if (i0.equals(F.C0)) {
            return null;
        }
        if (i1.isNegative()) {
            return F.fraction(F.C1, i0.pow(((IInteger)i1.negate()).getBigNumerator().intValue()));
        }
        return i0.pow(i1.getBigNumerator().intValue());
    }

    @Override
    public IExpr e2ObjArg(IExpr o0, IExpr o1) {
        EvalEngine ee = EvalEngine.get();
        if (ee.isNumericMode()) {
            if (o0.equals(F.CD0)) {
                if (o1.equals(F.CD0)) {
                    throw new DivisionByZero("0^0");
                }
                if (o1 instanceof ISignedNumber && ((ISignedNumber)o1).isNegative()) {
                    throw new DivisionByZero("");
                }
                return F.CD0;
            }
            if (o1.equals(F.CD0)) {
                return F.CD1;
            }
            if (o1.equals(F.CD1)) {
                return o0;
            }
            if (o0.equals(F.CD1)) {
                return F.CD1;
            }
        }
        if (o0.equals(F.Indeterminate) || o1.equals(F.Indeterminate)) {
            return F.Indeterminate;
        }
        if (o0.equals(F.C0)) {
            if (o1.equals(F.C0)) {
                ee.getOutPrintStream().println("Infinite expression 0^0");
                return F.Indeterminate;
            }
            if (o1 instanceof ISignedNumber && ((ISignedNumber)o1).isNegative()) {
                ee.getOutPrintStream().println("Infinite expression 1/0");
                return F.Indeterminate;
            }
            return F.C0;
        }
        if (o1.equals(F.C0)) {
            return F.C1;
        }
        if (o1.equals(F.C1)) {
            return o0;
        }
        if (o0.equals(F.C1)) {
            return F.C1;
        }
        if (o0.isAST(F.DirectedInfinity, 2) && o1.isSignedNumber()) {
            ISignedNumber is = (ISignedNumber)o1;
            if (o0.equals(F.CInfinity)) {
                if (is.isNegative()) {
                    return F.C0;
                }
                return F.CInfinity;
            }
            if (o0.equals(F.CNInfinity) && o1.isInteger()) {
                IInteger ii = (IInteger)o1;
                if (ii.isNegative()) {
                    return F.C0;
                }
                if (ii.isOdd()) {
                    return F.CNInfinity;
                }
                return F.CInfinity;
            }
        }
        if (o1.equals(F.CN1)) {
            if (o0.isInteger()) {
                return F.fraction(F.C1, (IInteger)o0);
            }
            if (o0.isFraction()) {
                return F.fraction(((IFraction)o0).getDenominator(), ((IFraction)o0).getNumerator());
            }
            if (o0.isComplex()) {
                return ((IComplex)o0).reciprocal();
            }
        }
        if (o0.isSignedNumber() && ((ISignedNumber)o0).isNegative() && o1.equals(F.C1D2)) {
            return F.Times((IExpr)F.CI, (IExpr)F.Power((IExpr)F.Times((IExpr)F.CN1, o0), o1));
        }
        if (o0.isAST()) {
            IAST arg0 = (IAST)o0;
            if (arg0.isTimes()) {
                IAST f0;
                if (o1 instanceof IInteger) {
                    return arg0.map(Functors.replace1st(F.Power((IExpr)F.Null, o1)));
                }
                if (o1 instanceof INumber && (f0 = arg0).size() > 1 && f0.get(1) instanceof INumber) {
                    return F.Times((IExpr)F.Power((IExpr)f0.get(1), o1), (IExpr)F.Power((IExpr)F.ast(f0, F.Times, true, 2, f0.size()), o1));
                }
            }
            if (arg0.isPower() && o1 instanceof IInteger) {
                return F.Power((IExpr)arg0.get(1), F.Times(o1, (IExpr)arg0.get(2)));
            }
        }
        return null;
    }

    @Override
    public IExpr e2FraArg(IFraction f0, IFraction f1) {
        int iNumer;
        if (f0.getNumerator().equals(F.C0)) {
            return F.C0;
        }
        if (f1.getNumerator().equals(F.C0)) {
            return F.C1;
        }
        if (f1.equals(F.C1D2) && f0.isNegative()) {
            return F.Times((IExpr)F.CI, (IExpr)F.Power((IExpr)f0.negate(), f1));
        }
        if (f1.equals(F.CN1D2) && f0.isNegative()) {
            return F.Times(F.CN1, F.CI, F.Power(f0.negate().inverse(), f1.negate()));
        }
        if (!f1.getDenominator().equals(F.C1)) {
            IInteger a;
            IInteger b;
            IFraction f0Temp = f0;
            if (f0.sign() < 0) {
                f0Temp = (IFraction)f0Temp.negate();
            }
            if (f1.isNegative()) {
                b = f0Temp.getNumerator();
                a = f0Temp.getDenominator();
            } else {
                a = f0Temp.getNumerator();
                b = f0Temp.getDenominator();
            }
            if (!f1.getNumerator().equals(F.C1)) {
                try {
                    int exp = f1.getNumerator().toInt();
                    if (exp < 0) {
                        exp *= -1;
                    }
                    a = a.pow(exp);
                    b = b.pow(exp);
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            IInteger root = f1.getDenominator();
            IInteger[] new_numer = this.calculateRoot(a, root);
            IInteger[] new_denom = this.calculateRoot(b, root);
            IFraction new_root = F.fraction(F.C1, root);
            if (new_numer != null) {
                if (new_denom != null) {
                    IRational p0 = null;
                    p0 = new_denom[1].equals(F.C1) ? new_numer[1] : F.fraction(new_numer[1], new_denom[1]);
                    if (f0.sign() < 0) {
                        return F.Times((IExpr)F.fraction(new_numer[0], new_denom[0]), (IExpr)F.Power((IExpr)p0.negate(), new_root));
                    }
                    return F.Times((IExpr)F.fraction(new_numer[0], new_denom[0]), (IExpr)F.Power((IExpr)p0, new_root));
                }
                if (a.equals(F.C1)) {
                    return null;
                }
                IRational p0 = null;
                p0 = b.equals(F.C1) ? new_numer[1] : F.fraction(new_numer[1], b);
                if (f0.sign() < 0) {
                    return F.Times((IExpr)new_numer[0], (IExpr)F.Power((IExpr)p0.negate(), new_root));
                }
                return F.Times((IExpr)new_numer[0], (IExpr)F.Power((IExpr)p0, new_root));
            }
            if (new_denom != null) {
                if (b.equals(F.C1)) {
                    return null;
                }
                IRational p0 = null;
                p0 = new_denom[1].equals(F.C1) ? a : F.fraction(a, new_denom[1]);
                if (f0.sign() < 0) {
                    return F.Times((IExpr)F.fraction(F.C1, new_denom[0]), (IExpr)F.Power((IExpr)p0.negate(), new_root));
                }
                return F.Times((IExpr)F.fraction(F.C1, new_denom[0]), (IExpr)F.Power((IExpr)p0, new_root));
            }
            return null;
        }
        try {
            iNumer = f1.getNumerator().toInt();
        }
        catch (ArithmeticException iob) {
            return null;
        }
        return f0.pow(iNumer);
    }

    private IInteger[] calculateRoot(IInteger a, IInteger root) {
        block5: {
            IInteger[] result;
            block8: {
                int n;
                block7: {
                    block6: {
                        result = new IInteger[2];
                        n = root.toInt();
                        if (n <= 0) break block5;
                        if (!a.equals(F.C1)) break block6;
                        return null;
                    }
                    if (!a.equals(F.CN1)) break block7;
                    return null;
                }
                result = a.nthRootSplit(n);
                if (!result[1].equals(a)) break block8;
                return null;
            }
            try {
                return result;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public IExpr eComIntArg(IComplex c0, IInteger i1) {
        if (c0.isZero()) {
            return F.C0;
        }
        if (i1.isZero()) {
            return F.C1;
        }
        return c0.pow(i1.getBigNumerator().intValue());
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1152);
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 2) {
            throw new UnsupportedOperationException();
        }
        return Math.pow(stack[top - 1], stack[top]);
    }
}

