/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.BigInteger;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class PowerMod
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 4) {
            return null;
        }
        int i = 1;
        while (i < functionList.size()) {
            if (!(functionList.get(i) instanceof IInteger)) {
                return null;
            }
            ++i;
        }
        try {
            BigInteger bigResult = PowerMod.powerMod(((IInteger)functionList.get(1)).getBigNumerator(), ((IInteger)functionList.get(2)).getBigNumerator(), ((IInteger)functionList.get(3)).getBigNumerator());
            return F.integer(bigResult);
        }
        catch (ArithmeticException ae) {
            ae.printStackTrace();
            return null;
        }
    }

    public static BigInteger powerMod(BigInteger a, BigInteger b, BigInteger m) throws ArithmeticException {
        return a.modPow(b, m);
    }
}

