/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.io.IOException;
import java.io.PrintStream;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.form.output.StringBufferWriter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class Print
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        EvalEngine engine = EvalEngine.get();
        PrintStream stream = engine.getOutPrintStream();
        if (stream == null) {
            stream = System.out;
        }
        try {
            StringBufferWriter buf = new StringBufferWriter();
            int i = 1;
            while (i < ast.size()) {
                if (ast.get(i) instanceof IStringX) {
                    buf.append(((IExpr)ast.get(i)).toString());
                } else {
                    OutputFormFactory.get().convert(buf, (IExpr)ast.get(i));
                }
                ++i;
            }
            stream.println(buf.toString());
        }
        catch (IOException e) {
            stream.println(e.getMessage());
        }
        return F.Null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

