/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class RootIntervals
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST lst) {
        if (lst.size() != 2) {
            return null;
        }
        return RootIntervals.croots(lst);
    }

    private static IAST croots(IAST lst) {
        ExprVariables eVar;
        block6: {
            eVar = new ExprVariables((IExpr)lst.get(1));
            if (eVar.isSize(1)) break block6;
            return null;
        }
        try {
            IExpr expr = F.evalExpandAll((IExpr)lst.get(1));
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            List<IExpr> varList = r.toList();
            ComplexRing<BigRational> cfac = new ComplexRing<BigRational>(new BigRational(1L));
            ComplexRootsSturm cr = new ComplexRootsSturm(cfac);
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, cfac);
            GenPolynomial<BigRational> poly = jas.expr2Poly(expr);
            SquarefreeAbstract<BigRational> engine = SquarefreeFactory.getImplementation(cfac);
            poly = engine.squarefreePart(poly);
            List roots = cr.complexRoots(poly);
            BigRational len = new BigRational(1L, 1000L);
            try {
                IAST resultList = F.List();
                for (Rectangle root : roots) {
                    IAST rectangleList = F.List();
                    Rectangle refine = cr.complexRootRefinement(root, poly, len);
                    rectangleList.add(JASConvert.jas2Complex(refine.getNW()));
                    rectangleList.add(JASConvert.jas2Complex(refine.getSW()));
                    rectangleList.add(JASConvert.jas2Complex(refine.getSE()));
                    rectangleList.add(JASConvert.jas2Complex(refine.getNE()));
                    resultList.add(rectangleList);
                }
                return resultList;
            }
            catch (InvalidBoundaryException e) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

