/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.ExprRingFactory;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.reflection.system.PossibleZeroQ;

public class Roots
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST lst) {
        if (lst.size() != 2) {
            return null;
        }
        return Roots.roots(lst);
    }

    protected static IExpr roots(IAST ast) {
        ExprVariables eVar = new ExprVariables((IExpr)ast.get(1));
        if (!eVar.isSize(1)) {
            return null;
        }
        IExpr expr = F.evalExpandAll((IExpr)ast.get(1));
        IAST variables = eVar.getVarList();
        return Roots.rootsOfVariable(expr, variables);
    }

    protected static IExpr rootsOfVariable(IExpr expr, IAST variables) {
        ASTRange r = new ASTRange(variables, 1);
        List<IExpr> varList = r.toList();
        try {
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, BigRational.ZERO);
            GenPolynomial<BigRational> rPoly = jas.expr2Poly(expr);
            return Roots.rootsOfPolynomial(rPoly, jas);
        }
        catch (Exception e) {
            try {
                JASConvert<IExpr> eJas = new JASConvert<IExpr>(varList, new ExprRingFactory());
                GenPolynomial<IExpr> ePoly = eJas.expr2Poly(expr);
                return Roots.rootsOfPolynomial(ePoly);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    private static IExpr rootsOfPolynomial(GenPolynomial<IExpr> ePoly) {
        long varDegree = ePoly.degree(0);
        IAST result = F.List();
        if (ePoly.isONE()) {
            return result;
        }
        if (varDegree <= 2L) {
            IExpr a = F.C0;
            IExpr b = F.C0;
            IExpr c = F.C0;
            for (Monomial<IExpr> monomial : ePoly) {
                IExpr coeff = monomial.coefficient();
                long lExp = monomial.exponent().getVal(0);
                if (lExp == 2L) {
                    a = coeff;
                    continue;
                }
                if (lExp == 1L) {
                    b = coeff;
                    continue;
                }
                if (lExp == 0L) {
                    c = coeff;
                    continue;
                }
                throw new ArithmeticException("Roots::Unexpected exponent value: " + lExp);
            }
            if (PossibleZeroQ.possibleZeroQ(a)) {
                result.add(F.Divide(c, b));
            } else {
                IAST iAST = F.Sqrt(F.Plus((IExpr)F.Sqr(b), (IExpr)F.Times(F.integer(-4L), a, c)));
                IAST rev2a = F.Divide(F.C1, a.multiply(F.C2));
                result.add(F.Times((IExpr)rev2a, (IExpr)F.Plus((IExpr)b.negate(), (IExpr)iAST)));
                result.add(F.Times((IExpr)rev2a, (IExpr)F.Plus((IExpr)b.negate(), iAST.negative())));
            }
            return result;
        }
        return null;
    }

    private static IAST rootsOfPolynomial(GenPolynomial<BigRational> poly, JASConvert<BigRational> jas) {
        FactorAbstract<BigRational> factorAbstract = FactorFactory.getImplementation(BigRational.ONE);
        SortedMap<GenPolynomial<BigRational>, Long> map = factorAbstract.baseFactors(poly);
        IAST result = F.List();
        for (Map.Entry<GenPolynomial<BigRational>, Long> entry : map.entrySet()) {
            GenPolynomial<BigRational> key = entry.getKey();
            GenPolynomial iPoly = (GenPolynomial)jas.factorTerms(key)[2];
            Long val = entry.getValue();
            long varDegree = iPoly.degree(0);
            if (iPoly.isONE()) continue;
            if (varDegree <= 2L) {
                IInteger a = F.C0;
                IInteger b = F.C0;
                IInteger c = F.C0;
                for (Monomial monomial : iPoly) {
                    BigInteger coeff = (BigInteger)monomial.coefficient();
                    long lExp = monomial.exponent().getVal(0);
                    if (lExp == 2L) {
                        a = F.integer(coeff.getVal());
                        continue;
                    }
                    if (lExp == 1L) {
                        b = F.integer(coeff.getVal());
                        continue;
                    }
                    if (lExp == 0L) {
                        c = F.integer(coeff.getVal());
                        continue;
                    }
                    throw new ArithmeticException("Roots::Unexpected exponent value: " + lExp);
                }
                if (a.equals(F.C0)) {
                    IFraction rat = F.fraction(c, b);
                    result.add(rat.negate());
                    continue;
                }
                IAST sqrt = F.Sqrt(F.Plus((IExpr)F.Sqr(b), (IExpr)F.Times(F.integer(-4L), a, c)));
                IFraction rev2a = F.fraction(F.C1, a.multiply(F.C2));
                result.add(F.Times((IExpr)rev2a, (IExpr)F.Plus((IExpr)b.negate(), (IExpr)sqrt)));
                result.add(F.Times((IExpr)rev2a, (IExpr)F.Plus((IExpr)b.negate(), sqrt.negative())));
                continue;
            }
            result.add(F.Power((IExpr)jas.integerPoly2Expr(iPoly), F.integer(val)));
        }
        return result;
    }
}

