/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class Select
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() == 3 && functionList.get(1) instanceof IAST) {
            return Select.select((IAST)functionList.get(1), (IExpr)functionList.get(2));
        }
        if (functionList.size() == 4 && functionList.get(1) instanceof IAST && functionList.get(3) instanceof IInteger) {
            int resultLimit = Validate.checkIntType(functionList, 3);
            return Select.select((IAST)functionList.get(1), (IExpr)functionList.get(2), resultLimit);
        }
        return null;
    }

    public static IAST select(IAST list, IExpr head) {
        return list.args().select(list.copyHead(), Predicates.isTrue(head));
    }

    public static IAST select(IAST list, IExpr head, int resultLimit) {
        return list.args().select(list.copyHead(), Predicates.isTrue(head), resultLimit);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

