/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.ICreatePatternMatcher;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Set
implements IFunctionEvaluator,
ICreatePatternMatcher {
    public static IExpr evalLeftHandSide(IExpr leftHandSide) {
        return Set.evalLeftHandSide(leftHandSide, EvalEngine.get());
    }

    public static IExpr evalLeftHandSide(IExpr leftHandSide, EvalEngine engine) {
        IAST temp;
        if (leftHandSide instanceof IAST && (temp = engine.evalSetAttributes((IAST)leftHandSide)) != null) {
            leftHandSide = temp;
        }
        return leftHandSide;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        IExpr leftHandSide = (IExpr)ast.get(1);
        IExpr rightHandSide = (IExpr)ast.get(2);
        Object[] result = rightHandSide.isAST(F.Condition, 3) ? this.createPatternMatcher(leftHandSide, (IExpr)((IAST)rightHandSide).get(1), (IExpr)((IAST)rightHandSide).get(2)) : this.createPatternMatcher(leftHandSide, rightHandSide, null);
        return (IExpr)result[1];
    }

    @Override
    public Object[] createPatternMatcher(IExpr leftHandSide, IExpr rightHandSide, IExpr condition) throws RuleCreationError {
        Object[] result = new Object[2];
        EvalEngine engine = EvalEngine.get();
        leftHandSide = Set.evalLeftHandSide(leftHandSide, engine);
        try {
            rightHandSide = engine.evaluate(rightHandSide);
        }
        catch (ReturnException e) {
            rightHandSide = e.getValue();
        }
        result[0] = null;
        result[1] = rightHandSide;
        if (leftHandSide instanceof ISymbol) {
            ISymbol lhsSymbol = (ISymbol)leftHandSide;
            if (lhsSymbol.hasLocalVariableStack()) {
                lhsSymbol.set(rightHandSide);
                return result;
            }
            result[0] = lhsSymbol.putDownRule(F.Set, true, leftHandSide, rightHandSide, condition);
            return result;
        }
        if (leftHandSide instanceof IAST) {
            ISymbol lhsSymbol = ((IAST)leftHandSide).topHead();
            result[0] = lhsSymbol.putDownRule(F.Set, false, leftHandSide, rightHandSide, condition);
            return result;
        }
        throw new RuleCreationError(leftHandSide);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

