/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IConstantHeaders;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class SetAttributes
extends AbstractFunctionEvaluator
implements IConstantHeaders {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 3) {
            throw new WrongNumberOfArguments(functionList, 2, functionList.size() - 1);
        }
        if (functionList.get(1) instanceof ISymbol) {
            ISymbol sym = (ISymbol)functionList.get(1);
            if (!EvalEngine.get().isPackageMode() && Config.SERVER_MODE && sym.toString().charAt(0) != '$') {
                throw new RuleCreationError(sym);
            }
            if (functionList.get(2) instanceof ISymbol) {
                if ((ISymbol)functionList.get(2) == F.Flat) {
                    sym.setAttributes(8);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.Listable) {
                    sym.setAttributes(128);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.OneIdentity) {
                    sym.setAttributes(1);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.Orderless) {
                    sym.setAttributes(4);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.HoldAll) {
                    sym.setAttributes(96);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.HoldFirst) {
                    sym.setAttributes(32);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.HoldRest) {
                    sym.setAttributes(64);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.NHoldAll) {
                    sym.setAttributes(8192);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.NHoldFirst) {
                    sym.setAttributes(16384);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.NHoldRest) {
                    sym.setAttributes(32768);
                    return F.Null;
                }
                if ((ISymbol)functionList.get(2) == F.NumericFunction) {
                    sym.setAttributes(1024);
                    return F.Null;
                }
            } else if (functionList.get(2) instanceof IAST && ((IAST)functionList.get(2)).head() == F.List) {
                IAST lst = (IAST)functionList.get(2);
                int symbolAttributes = 0;
                int i = 1;
                while (i < lst.size()) {
                    if ((ISymbol)lst.get(i) == F.Flat) {
                        sym.setAttributes(symbolAttributes | 8);
                    }
                    if ((ISymbol)lst.get(i) == F.Listable) {
                        sym.setAttributes(symbolAttributes | 0x80);
                    }
                    if ((ISymbol)lst.get(i) == F.OneIdentity) {
                        sym.setAttributes(symbolAttributes | 1);
                    }
                    if ((ISymbol)lst.get(i) == F.Orderless) {
                        sym.setAttributes(symbolAttributes | 4);
                    }
                    if ((ISymbol)lst.get(i) == F.HoldAll) {
                        sym.setAttributes(symbolAttributes | 0x60);
                    }
                    if ((ISymbol)lst.get(i) == F.HoldFirst) {
                        sym.setAttributes(symbolAttributes | 0x20);
                    }
                    if ((ISymbol)lst.get(i) == F.HoldRest) {
                        sym.setAttributes(symbolAttributes | 0x40);
                    }
                    if ((ISymbol)lst.get(i) == F.NHoldAll) {
                        sym.setAttributes(symbolAttributes | 0x2000);
                    }
                    if ((ISymbol)lst.get(i) == F.NHoldFirst) {
                        sym.setAttributes(symbolAttributes | 0x4000);
                    }
                    if ((ISymbol)lst.get(i) == F.NHoldRest) {
                        sym.setAttributes(symbolAttributes | 0x8000);
                    }
                    if ((ISymbol)lst.get(i) == F.NumericFunction) {
                        sym.setAttributes(symbolAttributes | 0x400);
                    }
                    symbolAttributes = sym.getAttributes();
                    ++i;
                }
                return F.Null;
            }
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(32);
    }
}

