/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.ICreatePatternMatcher;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Set;

public class SetDelayed
implements IFunctionEvaluator,
ICreatePatternMatcher {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        IExpr leftHandSide = (IExpr)ast.get(1);
        IExpr rightHandSide = (IExpr)ast.get(2);
        if (rightHandSide.isAST("Condition", 3)) {
            this.createPatternMatcher(leftHandSide, (IExpr)((IAST)rightHandSide).get(1), (IExpr)((IAST)rightHandSide).get(2));
        } else {
            this.createPatternMatcher(leftHandSide, rightHandSide, null);
        }
        return F.Null;
    }

    @Override
    public Object[] createPatternMatcher(IExpr leftHandSide, IExpr rightHandSide, IExpr condition) throws RuleCreationError {
        Object[] result = new Object[2];
        EvalEngine engine = EvalEngine.get();
        leftHandSide = Set.evalLeftHandSide(leftHandSide, engine);
        result[0] = null;
        result[1] = rightHandSide;
        if (leftHandSide instanceof ISymbol) {
            ISymbol lhsSymbol = (ISymbol)leftHandSide;
            if (lhsSymbol.hasLocalVariableStack()) {
                lhsSymbol.set(rightHandSide);
                return result;
            }
            result[0] = lhsSymbol.putDownRule(F.SetDelayed, true, leftHandSide, rightHandSide, condition);
            return result;
        }
        if (leftHandSide instanceof IAST) {
            ISymbol lhsSymbol = ((IAST)leftHandSide).topHead();
            result[0] = lhsSymbol.putDownRule(F.SetDelayed, false, leftHandSide, rightHandSide, condition);
            return result;
        }
        throw new RuleCreationError(leftHandSide);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

