/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.LeafCount;
import org.matheclipse.core.visit.AbstractVisitorBoolean;
import org.matheclipse.core.visit.VisitorExpr;

public class Simplify
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr expr = (IExpr)ast.get(1);
        int minCounter = LeafCount.leafCount(expr);
        IExpr result = expr;
        int count = 0;
        IExpr temp = expr.accept(new SimplifyVisitor());
        while (temp != null) {
            count = LeafCount.leafCount(temp);
            if (count < minCounter) {
                minCounter = count;
                result = temp;
                temp = result.accept(new SimplifyVisitor());
                continue;
            }
            return result;
        }
        return result;
    }

    public static class IsBasicExpressionVisitor
    extends AbstractVisitorBoolean {
        @Override
        public boolean visit(IAST ast) {
            if (ast.isTimes() || ast.isPlus()) {
                int i = 1;
                while (i < ast.size()) {
                    if (!((IExpr)ast.get(i)).accept(this)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (ast.isPower() && ast.get(2) instanceof IInteger) {
                return ((IExpr)ast.get(1)).accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(IComplex element) {
            return true;
        }

        @Override
        public boolean visit(IComplexNum element) {
            return true;
        }

        @Override
        public boolean visit(IFraction element) {
            return true;
        }

        @Override
        public boolean visit(IInteger element) {
            return true;
        }

        @Override
        public boolean visit(INum element) {
            return true;
        }

        @Override
        public boolean visit(ISymbol symbol) {
            return true;
        }
    }

    class SimplifyVisitor
    extends VisitorExpr {
        final IsBasicExpressionVisitor isBasicAST = new IsBasicExpressionVisitor();

        private IExpr tryTransformations(IAST plusAST, IExpr test) {
            IExpr result = null;
            int minCounter = LeafCount.leafCount(plusAST);
            try {
                IExpr temp = F.evalExpandAll(test);
                int count = LeafCount.leafCount(temp);
                if (count < minCounter) {
                    minCounter = count;
                    result = temp;
                }
            }
            catch (WrongArgumentType wrongArgumentType) {
                // empty catch block
            }
            return result;
        }

        private IExpr tryTransformations(IExpr expr) {
            IExpr result = null;
            if (expr instanceof IAST) {
                int count;
                IExpr temp;
                int minCounter = LeafCount.leafCount(expr);
                try {
                    temp = F.evalExpandAll(expr);
                    count = LeafCount.leafCount(temp);
                    if (count < minCounter) {
                        minCounter = count;
                        result = temp;
                    }
                }
                catch (WrongArgumentType wrongArgumentType) {
                    // empty catch block
                }
                try {
                    temp = F.eval(F.Together(expr));
                    count = LeafCount.leafCount(temp);
                    if (count < minCounter) {
                        minCounter = count;
                        result = temp;
                    }
                }
                catch (WrongArgumentType wrongArgumentType) {
                    // empty catch block
                }
                try {
                    temp = F.eval(F.Factor(expr));
                    count = LeafCount.leafCount(temp);
                    if (count < minCounter) {
                        minCounter = count;
                        result = temp;
                    }
                }
                catch (WrongArgumentType wrongArgumentType) {
                    // empty catch block
                }
                try {
                    temp = F.eval(F.Apart(expr));
                    count = LeafCount.leafCount(temp);
                    if (count < minCounter) {
                        minCounter = count;
                        result = temp;
                    }
                }
                catch (WrongArgumentType wrongArgumentType) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public IExpr visit(IAST ast) {
            IExpr temp = this.visitAST(ast);
            if (temp != null) {
                return temp;
            }
            if (ast.isPlus()) {
                IAST basicPlus = F.Plus();
                IAST restPlus = F.Plus();
                int i = 1;
                while (i < ast.size()) {
                    temp = (IExpr)ast.get(i);
                    if (temp.accept(this.isBasicAST)) {
                        basicPlus.add(temp);
                    } else {
                        restPlus.add(temp);
                    }
                    ++i;
                }
                if (basicPlus.size() > 1 && (temp = basicPlus.size() == 2 ? this.tryTransformations((IExpr)basicPlus.get(1)) : this.tryTransformations(basicPlus)) != null) {
                    if (restPlus.size() == 1) {
                        return temp;
                    }
                    return F.Plus(temp, (IExpr)restPlus);
                }
            } else if (ast.isTimes()) {
                IAST basicTimes = F.Times();
                IAST restTimes = F.Times();
                INumber number = null;
                if (ast.get(1) instanceof INumber) {
                    number = (INumber)ast.get(1);
                }
                int i = 1;
                while (i < ast.size()) {
                    temp = (IExpr)ast.get(i);
                    if (temp.accept(this.isBasicAST)) {
                        if (i != 1 && number != null) {
                            IExpr reduced;
                            if (temp.isPlus()) {
                                reduced = this.tryToReduceNumericFactor(ast, temp, number, i);
                                if (reduced != null) {
                                    return reduced;
                                }
                            } else if (temp.isPower() && ((IExpr)((IAST)temp).get(1)).isPlus() && ((IExpr)((IAST)temp).get(2)).equals(F.CN1) && (reduced = this.tryToReduceNumericFactor(ast, (IExpr)((IAST)temp).get(1), number.inverse(), i)) != null) {
                                return F.Power(reduced, F.CN1);
                            }
                        }
                        basicTimes.add(temp);
                    } else {
                        restTimes.add(temp);
                    }
                    ++i;
                }
                if (basicTimes.size() > 1 && (temp = basicTimes.size() == 2 ? this.tryTransformations((IExpr)basicTimes.get(1)) : this.tryTransformations(basicTimes)) != null) {
                    if (restTimes.size() == 1) {
                        return temp;
                    }
                    return F.Times(temp, (IExpr)restTimes);
                }
            }
            temp = F.evalExpandAll(ast);
            int minCounter = LeafCount.leafCount(ast);
            int count = LeafCount.leafCount(temp);
            if (count < minCounter) {
                return temp;
            }
            return null;
        }

        private IExpr tryToReduceNumericFactor(IAST ast, IExpr temp, IExpr arg1, int i) {
            IExpr expandedAst = this.tryTransformations((IAST)temp, F.Times(arg1, temp));
            if (expandedAst != null) {
                IAST result = F.Times();
                ast.range(2, ast.size()).toList(result);
                result.set(i - 1, expandedAst);
                return result;
            }
            return null;
        }
    }
}

