/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.SingularValueDecompositionImpl;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class SingularValueDecomposition
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST function) {
        try {
            if (function.size() == 2) {
                IAST list = (IAST)function.get(1);
                RealMatrix matrix = Convert.list2RealMatrix(list);
                SingularValueDecompositionImpl svd = new SingularValueDecompositionImpl(matrix);
                RealMatrix uMatrix = svd.getU();
                RealMatrix sMatrix = svd.getS();
                RealMatrix vMatrix = svd.getV();
                IAST result = F.List();
                IAST uMatrixAST = Convert.realMatrix2List(uMatrix);
                IAST sMatrixAST = Convert.realMatrix2List(sMatrix);
                IAST vMatrixAST = Convert.realMatrix2List(vMatrix);
                result.add(uMatrixAST);
                result.add(sMatrixAST);
                result.add(vMatrixAST);
                return result;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }
}

