/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.LeafCount;
import org.matheclipse.core.reflection.system.PossibleZeroQ;
import org.matheclipse.core.reflection.system.Roots;

public class Solve
extends AbstractFunctionEvaluator {
    private static IAST analyzeSublist(ArrayList<ExprAnalyzer> analyzerList, IAST vars, IAST resultList, IAST matrix, IAST vector) throws NoSolution {
        Collections.sort(analyzerList);
        int currEquation = 0;
        while (currEquation < analyzerList.size()) {
            ExprAnalyzer exprAnalyzer = analyzerList.get(currEquation);
            if (exprAnalyzer.getNumberOfVars() == 0) {
                IExpr expr = exprAnalyzer.getExpr();
                if (!expr.isZero()) {
                    if (expr instanceof INumber) {
                        throw new NoSolution(0);
                    }
                    if (!PossibleZeroQ.possibleZeroQ(expr)) {
                        throw new NoSolution(1);
                    }
                }
            } else {
                if (exprAnalyzer.getNumberOfVars() == 1 && exprAnalyzer.isLinearOrPolynomial()) {
                    IAST listOfRules = Solve.rootsOfUnivariatePolynomial(exprAnalyzer);
                    if (listOfRules != null) {
                        boolean evaled = false;
                        ++currEquation;
                        int k = 1;
                        while (k < listOfRules.size()) {
                            block22: {
                                if (currEquation >= analyzerList.size()) {
                                    resultList.add(F.List((IExpr)listOfRules.getAST(k)));
                                    evaled = true;
                                } else {
                                    ArrayList<ExprAnalyzer> subAnalyzerList = new ArrayList<ExprAnalyzer>();
                                    int i = currEquation;
                                    while (i < analyzerList.size()) {
                                        IExpr expr = analyzerList.get(i).getExpr();
                                        IExpr temp = expr.replaceAll(listOfRules.getAST(k));
                                        if (temp != null) {
                                            expr = F.eval(temp);
                                            exprAnalyzer = new ExprAnalyzer(expr, vars);
                                            exprAnalyzer.analyze(expr);
                                        } else {
                                            exprAnalyzer = analyzerList.get(i);
                                        }
                                        subAnalyzerList.add(exprAnalyzer);
                                        ++i;
                                    }
                                    try {
                                        IAST subResultList = Solve.analyzeSublist(subAnalyzerList, vars, F.List(), matrix, vector);
                                        if (subResultList != null) {
                                            evaled = true;
                                            for (IExpr expr : subResultList) {
                                                if (expr.isList()) {
                                                    IAST list = (IAST)expr;
                                                    list.add(1, listOfRules.getAST(k));
                                                    resultList.add(list);
                                                    continue;
                                                }
                                                resultList.add(expr);
                                            }
                                        }
                                    }
                                    catch (NoSolution e) {
                                        if (e.getType() != 0) break block22;
                                        evaled = true;
                                    }
                                }
                            }
                            ++k;
                        }
                        if (evaled) {
                            return resultList;
                        }
                    }
                    throw new NoSolution(1);
                }
                if (exprAnalyzer.isLinear()) {
                    matrix.add(F.eval(exprAnalyzer.getRow()));
                    vector.add(F.eval(F.Negate(exprAnalyzer.getValue())));
                } else {
                    throw new NoSolution(1);
                }
            }
            ++currEquation;
        }
        return resultList;
    }

    private static IAST rootsOfUnivariatePolynomial(ExprAnalyzer exprAnalyzer) {
        IExpr expr = exprAnalyzer.getExpr();
        Iterator<ISymbol> iterator = exprAnalyzer.getSymbolSet().iterator();
        if (iterator.hasNext()) {
            ISymbol sym = iterator.next();
            IExpr temp = Roots.rootsOfVariable(expr, F.List((IExpr)sym));
            IAST resultList = F.List();
            if (temp.isASTSizeGE(F.List, 2)) {
                IAST rootsList = (IAST)temp;
                for (IExpr root : rootsList) {
                    IAST rule = F.Rule(sym, root);
                    resultList.add(rule);
                }
                return resultList;
            }
            return null;
        }
        return null;
    }

    private IAST checkEquations(IAST ast, int position) {
        IAST termsEqualZeroList = F.List();
        IAST eqns = null;
        if (((IExpr)ast.get(position)).isList()) {
            eqns = (IAST)ast.get(position);
            int i = 1;
            while (i < eqns.size()) {
                if (!((IExpr)eqns.get(i)).isAST(F.Equal, 3)) {
                    throw new WrongArgumentType(eqns, (IExpr)eqns.get(i), i, "Equal[] expression (a==b) expected");
                }
                IAST eq = (IAST)eqns.get(i);
                termsEqualZeroList.add(F.evalExpandAll(F.Subtract((IExpr)eq.get(1), (IExpr)eq.get(2))));
                ++i;
            }
        } else if (((IExpr)ast.get(position)).isAST(F.Equal, 3)) {
            IAST eq = (IAST)ast.get(position);
            termsEqualZeroList.add(F.evalExpandAll(F.Subtract((IExpr)eq.get(1), (IExpr)eq.get(2))));
        } else {
            throw new WrongArgumentType(ast, (IExpr)ast.get(1), 1, "Equal[] expression (a==b) expected");
        }
        return termsEqualZeroList;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        IAST resultList;
        block7: {
            Validate.checkSize(ast, 3);
            IAST vars = Validate.checkSymbolOrSymbolList(ast, 2);
            IAST termsEqualZeroList = this.checkEquations(ast, 1);
            ArrayList<ExprAnalyzer> analyzerList = new ArrayList<ExprAnalyzer>();
            for (IExpr expr : termsEqualZeroList) {
                ExprAnalyzer exprAnalyzer = new ExprAnalyzer(expr, vars);
                exprAnalyzer.analyze(expr);
                analyzerList.add(exprAnalyzer);
            }
            IAST matrix = F.List();
            IAST vector = F.List();
            try {
                resultList = F.List();
                resultList = Solve.analyzeSublist(analyzerList, vars, resultList, matrix, vector);
                if (vector.size() <= 1) break block7;
                IExpr temp = F.eval(F.LinearSolve(matrix, vector));
                if (temp.isASTSizeGE(F.List, 2)) {
                    IAST rootsList = (IAST)temp;
                    IAST list = F.List();
                    int j = 1;
                    while (j < vars.size()) {
                        IAST rule = F.Rule((IExpr)vars.get(j), (IExpr)rootsList.get(j));
                        list.add(rule);
                        ++j;
                    }
                    resultList.add(list);
                    break block7;
                }
                return null;
            }
            catch (NoSolution e) {
                if (e.getType() == 0) {
                    return F.List();
                }
                return null;
            }
        }
        return resultList;
    }

    private static class ExprAnalyzer
    implements Comparable<ExprAnalyzer> {
        public static final int LINEAR = 0;
        public static final int OTHERS = 2;
        public static final int POLYNOMIAL = 1;
        int equationType;
        final IExpr expr;
        int leafCount;
        IAST row;
        HashSet<ISymbol> symbolSet;
        IAST value;
        final IAST vars;

        public ExprAnalyzer(IExpr expr, IAST vars) {
            this.expr = expr;
            this.vars = vars;
            this.symbolSet = new HashSet();
            this.leafCount = 0;
            this.reset();
        }

        public void analyze(IExpr eqExpr) {
            if (eqExpr.isFree(Predicates.in(this.vars))) {
                ++this.leafCount;
                this.value.add(eqExpr);
            } else if (eqExpr.isPlus()) {
                ++this.leafCount;
                IAST arg = (IAST)eqExpr;
                int i = 1;
                while (i < arg.size()) {
                    IExpr expr = (IExpr)arg.get(i);
                    if (expr.isFree(Predicates.in(this.vars))) {
                        ++this.leafCount;
                        this.value.add(expr);
                    } else {
                        this.getPlusEquationType(expr);
                    }
                    ++i;
                }
            } else {
                this.getPlusEquationType(eqExpr);
            }
        }

        @Override
        public int compareTo(ExprAnalyzer o) {
            if (this.symbolSet.size() != o.symbolSet.size()) {
                if (this.symbolSet.size() < o.symbolSet.size()) {
                    return -1;
                }
                return 1;
            }
            if (this.equationType != o.equationType) {
                if (this.equationType < o.equationType) {
                    return -1;
                }
                return 1;
            }
            if (this.leafCount != o.leafCount) {
                if (this.leafCount < o.leafCount) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        public IExpr getExpr() {
            return this.expr;
        }

        public int getNumberOfVars() {
            return this.symbolSet.size();
        }

        private void getPlusEquationType(IExpr eqExpr) {
            if (eqExpr.isTimes()) {
                ISymbol sym = null;
                ++this.leafCount;
                IAST arg = (IAST)eqExpr;
                int i = 1;
                while (i < arg.size()) {
                    IExpr expr = (IExpr)arg.get(i);
                    if (expr.isFree(Predicates.in(this.vars))) {
                        ++this.leafCount;
                    } else if (expr.isSymbol()) {
                        ++this.leafCount;
                        int j = 1;
                        while (j < this.vars.size()) {
                            if (((IExpr)this.vars.get(j)).equals(expr)) {
                                this.symbolSet.add((ISymbol)expr);
                                if (sym != null) {
                                    if (this.equationType == 0) {
                                        this.equationType = 1;
                                    }
                                } else {
                                    sym = (ISymbol)expr;
                                    if (this.equationType == 0) {
                                        IAST cloned = arg.clone();
                                        cloned.remove(i);
                                        this.row.set(j, F.Plus((IExpr)this.row.get(j), (IExpr)cloned));
                                    }
                                }
                            }
                            ++j;
                        }
                    } else if (expr.isPower() && ((IExpr)((IAST)expr).get(2)).isInteger()) {
                        if (this.equationType == 0) {
                            this.equationType = 1;
                        }
                        this.getTimesEquationType((IExpr)((IAST)expr).get(1));
                    } else {
                        this.leafCount += LeafCount.leafCount(eqExpr);
                        if (this.equationType <= 1) {
                            this.equationType = 2;
                        }
                    }
                    ++i;
                }
                if (this.equationType == 0 && sym == null) {
                    System.out.println("sym == null???");
                }
            } else {
                this.getTimesEquationType(eqExpr);
            }
        }

        public IAST getRow() {
            return this.row;
        }

        public HashSet<ISymbol> getSymbolSet() {
            return this.symbolSet;
        }

        private void getTimesEquationType(IExpr expr) {
            if (expr.isSymbol()) {
                ++this.leafCount;
                int i = 1;
                while (i < this.vars.size()) {
                    if (((IExpr)this.vars.get(i)).equals(expr)) {
                        this.symbolSet.add((ISymbol)expr);
                        if (this.equationType == 0) {
                            this.row.set(i, F.Plus((IExpr)this.row.get(i), (IExpr)F.C1));
                        }
                    }
                    ++i;
                }
            } else if (expr.isFree(Predicates.in(this.vars))) {
                ++this.leafCount;
                this.value.add(expr);
            } else if (expr.isPower() && ((IExpr)((IAST)expr).get(2)).isInteger()) {
                if (this.equationType == 0) {
                    this.equationType = 1;
                }
                this.getTimesEquationType((IExpr)((IAST)expr).get(1));
            } else {
                this.leafCount += LeafCount.leafCount(expr);
                if (this.equationType <= 1) {
                    this.equationType = 2;
                }
            }
        }

        public IAST getValue() {
            return this.value;
        }

        public boolean isLinear() {
            return this.equationType == 0;
        }

        public boolean isLinearOrPolynomial() {
            return this.equationType == 0 || this.equationType == 1;
        }

        public void reset() {
            this.row = F.List();
            int i = 1;
            while (i < this.vars.size()) {
                this.row.add(F.C0);
                ++i;
            }
            this.value = F.Plus();
            this.equationType = 0;
        }
    }

    private static class NoSolution
    extends Exception {
        public static final int NO_SOLUTION_FOUND = 1;
        public static final int WRONG_SOLUTION = 0;
        final int solType;

        public NoSolution(int solType) {
            this.solType = solType;
        }

        public int getType() {
            return this.solType;
        }
    }
}

