/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;

public class SquareFreeQ
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST lst) {
        if (lst.size() != 2 && lst.size() != 3) {
            return null;
        }
        if (lst.get(1) instanceof IRational) {
            return null;
        }
        ExprVariables eVar = new ExprVariables((IExpr)lst.get(1));
        if (eVar.isSize(0)) {
            if (((IExpr)lst.get(1)).isAtom()) {
                return F.False;
            }
            eVar.add(F.symbol("x"));
        }
        if (!eVar.isSize(1)) {
            throw new WrongArgumentType(lst, (IExpr)lst.get(1), 1, "SquareFreeQ only implemented for univariate polynomials");
        }
        try {
            IExpr expr = F.evalExpandAll((IExpr)lst.get(1));
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            List<IExpr> varList = r.toList();
            if (lst.size() == 3) {
                return F.bool(SquareFreeQ.isSquarefreeWithOption(lst, expr, varList));
            }
            return F.bool(SquareFreeQ.isSquarefree(expr, varList));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isSquarefree(IExpr expr, List<IExpr> varList) {
        JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, BigRational.ZERO);
        GenPolynomial<BigRational> poly = jas.expr2Poly(expr);
        FactorAbstract<BigRational> factorAbstract = FactorFactory.getImplementation(BigRational.ONE);
        return factorAbstract.isSquarefree(poly);
    }

    public static boolean isSquarefreeWithOption(IAST lst, IExpr expr, List<IExpr> varList) {
        Options options = new Options(lst.topHead(), lst, 2);
        IExpr option = options.getOption("Modulus");
        if (option != null && option instanceof IInteger) {
            try {
                BigInteger value = ((IInteger)option).getBigNumerator();
                int intValue = ((IInteger)option).toInt();
                ModIntegerRing modIntegerRing = new ModIntegerRing(intValue, value.isProbablePrime(32));
                JASConvert<ModInteger> jas = new JASConvert<ModInteger>(varList, modIntegerRing);
                GenPolynomial<ModInteger> poly = jas.expr2Poly(expr);
                FactorAbstract<ModInteger> factorAbstract = FactorFactory.getImplementation(modIntegerRing);
                return factorAbstract.isSquarefree(poly);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return false;
    }
}

