/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Taylor
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() == 3 && ((IExpr)ast.get(2)).isVector() == 3) {
            IAST list = (IAST)ast.get(2);
            int lowerLimit = Validate.checkIntType(list, 2, Integer.MIN_VALUE);
            if (lowerLimit != 0) {
                return null;
            }
            int upperLimit = Validate.checkIntType(list, 3, Integer.MIN_VALUE);
            if (upperLimit < 0) {
                return null;
            }
            IAST fadd = F.Plus();
            fadd.add(F.ReplaceAll((IExpr)ast.get(1), F.Rule((IExpr)list.get(1), (IExpr)list.get(2))));
            IExpr temp = (IExpr)ast.get(1);
            IAST factor = null;
            int i = 1;
            while (i <= upperLimit) {
                temp = F.D(temp, (IExpr)list.get(1));
                factor = F.Times((IExpr)F.Power((IExpr)F.Factorial(F.integer(i)), F.CN1), (IExpr)F.Power((IExpr)F.Plus((IExpr)list.get(1), (IExpr)F.Times((IExpr)F.CN1, (IExpr)list.get(2))), F.integer(i)));
                fadd.add(F.Times((IExpr)F.ReplaceAll(temp, F.Rule((IExpr)list.get(1), (IExpr)list.get(2))), (IExpr)factor));
                ++i;
            }
            return fadd;
        }
        return null;
    }
}

