/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractArgMultiple;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Times
extends AbstractArgMultiple
implements INumeric {
    @Override
    public IExpr e2ComArg(IComplex c0, IComplex c1) {
        return c0.multiply(c1);
    }

    @Override
    public IExpr e2DblArg(INum d0, INum d1) {
        return d0.multiply(d1);
    }

    @Override
    public IExpr e2DblComArg(IComplexNum d0, IComplexNum d1) {
        return d0.multiply(d1);
    }

    @Override
    public IExpr e2FraArg(IFraction f0, IFraction f1) {
        return f0.multiply(f1);
    }

    @Override
    public IExpr e2IntArg(IInteger i0, IInteger i1) {
        return i0.multiply(i1);
    }

    @Override
    public IExpr e2ObjArg(IExpr o0, IExpr o1) {
        IAST f1;
        IAST f0;
        EvalEngine ee = EvalEngine.get();
        IExpr temp = null;
        if (ee.isNumericMode()) {
            if (o0.equals(F.CD0)) {
                if (o1.isAST(F.DirectedInfinity, 2)) {
                    return F.Indeterminate;
                }
                return F.CD0;
            }
            if (o1.equals(F.CD0)) {
                if (o0.isAST(F.DirectedInfinity, 2)) {
                    return F.Indeterminate;
                }
                return F.CD0;
            }
            if (o0.equals(F.CD1)) {
                return o1;
            }
            if (o1.equals(F.CD1)) {
                return o0;
            }
        }
        if (o0.equals(F.Indeterminate) || o1.equals(F.Indeterminate)) {
            return F.Indeterminate;
        }
        if (o0.equals(F.C0)) {
            if (o1.isAST(F.DirectedInfinity, 2)) {
                return F.Indeterminate;
            }
            return F.C0;
        }
        if (o1.equals(F.C0)) {
            if (o0.isAST(F.DirectedInfinity, 2)) {
                return F.Indeterminate;
            }
            return F.C0;
        }
        if (o0.equals(F.C1)) {
            return o1;
        }
        if (o1.equals(F.C1)) {
            return o0;
        }
        if (o0.equals(o1)) {
            return F.function(F.Power, o0, (IExpr)F.C2);
        }
        if (o0.isAST(F.DirectedInfinity, 2)) {
            temp = this.eInfinity(o0, o1);
        } else if (o1.isAST(F.DirectedInfinity, 2)) {
            temp = this.eInfinity(o1, o0);
        }
        if (temp != null) {
            return temp;
        }
        if (o0.isAST(F.Power, 3) && (f0 = (IAST)o0).get(2) instanceof INumber) {
            IAST f12;
            if (((IExpr)f0.get(1)).equals(o1)) {
                return F.Power(o1, F.Plus((IExpr)F.C1, (IExpr)f0.get(2)));
            }
            if (o1.isAST(F.Power, 3) && (f12 = (IAST)o1).get(2) instanceof INumber && ((IExpr)f0.get(1)).equals(f12.get(1))) {
                return F.Power((IExpr)f0.get(1), F.Plus((IExpr)f0.get(2), (IExpr)f12.get(2)));
            }
        }
        if (o1.isAST(F.Power, 3) && ((IAST)o1).get(2) instanceof IInteger && ((IExpr)(f1 = (IAST)o1).get(1)).equals(o0)) {
            return F.Power(o0, F.Plus((IExpr)F.C1, (IExpr)f1.get(2)));
        }
        return null;
    }

    private IExpr eInfinity(IExpr inf, IExpr o1) {
        if (inf.equals(F.CInfinity)) {
            if (o1.equals(F.CInfinity)) {
                return F.CInfinity;
            }
            if (o1.equals(F.CNInfinity)) {
                return F.CNInfinity;
            }
            if (o1 instanceof ISignedNumber) {
                if (((ISignedNumber)o1).isNegative()) {
                    return F.CNInfinity;
                }
                return F.CInfinity;
            }
        } else if (inf.equals(F.CNInfinity)) {
            if (o1.equals(F.CInfinity)) {
                return F.CNInfinity;
            }
            if (o1.equals(F.CNInfinity)) {
                return F.CInfinity;
            }
            if (o1 instanceof ISignedNumber) {
                if (((ISignedNumber)o1).isNegative()) {
                    return F.CInfinity;
                }
                return F.CNInfinity;
            }
        }
        return null;
    }

    @Override
    public IExpr eComIntArg(IComplex c0, IInteger i1) {
        return c0.multiply(F.complex(i1, F.C0));
    }

    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() == 3) {
            return this.binaryOperator((IExpr)functionList.get(1), (IExpr)functionList.get(2));
        }
        if (functionList.size() > 3) {
            ISymbol sym = functionList.topHead();
            IAST result = F.function(sym);
            IExpr temp = (IExpr)functionList.get(1);
            boolean evaled = false;
            int i = 2;
            while (i < functionList.size()) {
                IExpr tres = this.binaryOperator(temp, (IExpr)functionList.get(i));
                if (tres == null) {
                    int j = i + 1;
                    while (j < functionList.size()) {
                        tres = this.binaryOperator(temp, (IExpr)functionList.get(j));
                        if (tres != null) {
                            evaled = true;
                            temp = tres;
                            functionList.remove(j);
                            break;
                        }
                        ++j;
                    }
                    if (tres != null) continue;
                    result.add(temp);
                    if (i == functionList.size() - 1) {
                        result.add((IExpr)functionList.get(i));
                    } else {
                        temp = (IExpr)functionList.get(i);
                    }
                    ++i;
                    continue;
                }
                evaled = true;
                temp = tres;
                if (i == functionList.size() - 1) {
                    result.add(temp);
                }
                ++i;
            }
            if (evaled) {
                if (result.size() == 2 && (sym.getAttributes() & 1) == 1) {
                    return (IExpr)result.get(1);
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1165);
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        double result = 1.0;
        int i = top - size + 1;
        while (i < top + 1) {
            result *= stack[i];
            ++i;
        }
        return result;
    }
}

