/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class ToCharacterCode
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 2 || !(ast.get(1) instanceof IStringX)) {
            return null;
        }
        IAST resultList = F.List();
        resultList = (IAST)ToCharacterCode.toCharacterCode(((IExpr)ast.get(1)).toString(), "UTF-8", resultList);
        return resultList;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }

    public static List<IExpr> toCharacterCode(String unicodeInput, String inputEncoding, List<IExpr> list) {
        try {
            String utf8String = new String(unicodeInput.getBytes(inputEncoding), "UTF-8");
            int i = 0;
            while (i < utf8String.length()) {
                char characterCode = utf8String.charAt(i);
                list.add(F.integer(characterCode));
                ++i;
            }
            return list;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

