/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorExpr;
import org.matheclipse.parser.client.SyntaxError;

public class Together
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        IExpr expr;
        Validate.checkSize(ast, 2);
        if (((IExpr)ast.get(1)).isAST() && (expr = ((IExpr)ast.get(1)).accept(new TogetherVisitor())) != null) {
            return expr;
        }
        return (IExpr)ast.get(1);
    }

    public IExpr[] normalize(IExpr e1, IExpr e2) {
        ExprVariables eVar;
        block5: {
            try {
                eVar = new ExprVariables(e1);
                eVar.addVarList(e2);
                if (eVar.isSize(1)) break block5;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        ASTRange r = new ASTRange(eVar.getVarList(), 1);
        JASConvert<BigRational> jas = new JASConvert<BigRational>(r.toList(), BigRational.ZERO);
        GenPolynomial<BigRational> p1 = jas.expr2Poly(e1);
        GenPolynomial<BigRational> p2 = jas.expr2Poly(e2);
        GenPolynomial<BigRational> gcd = p1.gcd(p2);
        IExpr[] result = new IExpr[2];
        if (gcd.isONE()) {
            result[0] = jas.rationalPoly2Expr(p1);
            result[1] = jas.rationalPoly2Expr(p2);
        } else {
            result[0] = jas.rationalPoly2Expr(p1.divide(gcd));
            result[1] = jas.rationalPoly2Expr(p2.divide(gcd));
        }
        return result;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }

    class TogetherVisitor
    extends VisitorExpr {
        @Override
        public IExpr visit(IAST ast) {
            IExpr temp = this.visitAST(ast);
            IAST astTemp = ast;
            if (temp != null) {
                if (temp.isAST()) {
                    astTemp = (IAST)temp;
                } else {
                    return temp;
                }
            }
            if (astTemp.isPlus()) {
                return this.visitPlus(astTemp);
            }
            return astTemp;
        }

        private IExpr visitPlus(IAST plusAST) {
            IExpr[] result;
            if (plusAST.size() <= 1) {
                return plusAST;
            }
            IAST numer = F.ast(F.Plus, plusAST.size(), false);
            IAST denom = F.ast(F.Times, plusAST.size(), false);
            int i = 1;
            while (i < plusAST.size()) {
                numer.add(i, F.eval(F.Numerator((IExpr)plusAST.get(i))));
                denom.add(i, F.eval(F.Denominator((IExpr)plusAST.get(i))));
                ++i;
            }
            i = 1;
            while (i < plusAST.size()) {
                IAST ni = F.Times((IExpr)numer.get(i));
                int j = 1;
                while (j < plusAST.size()) {
                    IExpr temp;
                    if (i != j && !(temp = (IExpr)denom.get(j)).equals(F.C1)) {
                        ni.add(temp);
                    }
                    ++j;
                }
                numer.set(i, ni);
                ++i;
            }
            i = 1;
            while (denom.size() > i) {
                if (((IExpr)denom.get(i)).equals(F.C1)) {
                    denom.remove(i);
                    continue;
                }
                ++i;
            }
            IExpr exprNumerator = F.evalExpandAll(numer);
            if (denom.size() == 1) {
                return exprNumerator;
            }
            IExpr exprDenominator = F.evalExpandAll(denom);
            if (!exprDenominator.equals(F.C1) && (result = Together.this.normalize(exprNumerator, exprDenominator)) != null) {
                return F.Times(result[0], (IExpr)F.Power(result[1], F.CN1));
            }
            return F.Times(exprNumerator, (IExpr)F.Power(exprDenominator, F.CN1));
        }
    }
}

