/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Trace
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            throw new WrongNumberOfArguments(functionList, 1, functionList.size() - 1);
        }
        IExpr temp = (IExpr)functionList.get(1);
        IAST holdList = F.function(F.Hold);
        EvalEngine engine = EvalEngine.get();
        try {
            engine.setTraceMode(true);
            engine.setTraceList(F.List());
            engine.evaluate(temp);
        }
        finally {
            engine.setTraceMode(false);
        }
        IAST traceList = engine.getTraceList();
        engine.setTraceList(null);
        if (traceList.size() == 2) {
            holdList.add((IExpr)traceList.get(1));
        } else {
            holdList.add(traceList);
        }
        return holdList;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

