/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Transpose
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            throw new WrongNumberOfArguments(functionList, 1, functionList.size() - 1);
        }
        int[] dim = ((IExpr)functionList.get(1)).isMatrix();
        if (dim != null) {
            IAST mat = (IAST)functionList.get(1);
            IAST transposed = F.ast(F.List, dim[1], true);
            int i = 1;
            while (i <= dim[1]) {
                transposed.set(i, F.ast(F.List, dim[0], true));
                ++i;
            }
            int i2 = 1;
            while (i2 <= dim[0]) {
                AST row = (AST)mat.get(i2);
                int j = 1;
                while (j <= dim[1]) {
                    IAST trRow = (IAST)transposed.get(j);
                    trRow.set(i2, (IExpr)row.get(j));
                    ++j;
                }
                ++i2;
            }
            transposed.addEvalFlags(32);
            return transposed;
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

