/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.HashedOrderlessMatcher;
import org.matheclipse.core.visit.VisitorExpr;

public class TrigReduce
implements IFunctionEvaluator {
    private static HashedOrderlessMatcher ORDERLESS_MATCHER = new HashedOrderlessMatcher(true);

    @Override
    public IExpr evaluate(IAST ast) {
        IExpr temp;
        if (ast.size() != 2) {
            throw new WrongNumberOfArguments(ast, 1, ast.size() - 1);
        }
        TrigReduceVisitor trigReduceVisitor = new TrigReduceVisitor();
        IExpr result = temp = (IExpr)ast.get(1);
        while (temp != null) {
            result = F.evalExpandAll(temp);
            if ((temp = result.accept(trigReduceVisitor)) == null) continue;
            result = temp;
        }
        return result;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        ORDERLESS_MATCHER.setUpHashRule("Sin[x_]", "Cos[y_]", "Sin[x+y]/2+Sin[x-y]/2");
        ORDERLESS_MATCHER.setUpHashRule("Sin[x_]", "Sin[y_]", "Cos[x-y]/2-Cos[x+y]/2");
        ORDERLESS_MATCHER.setUpHashRule("Cos[x_]", "Cos[y_]", "Cos[x+y]/2+Cos[x-y]/2");
        symbol.setAttributes(128);
    }

    class TrigReduceVisitor
    extends VisitorExpr {
        @Override
        public IExpr visit(IAST ast) {
            IInteger n;
            if (ast.isTimes()) {
                IAST result = ORDERLESS_MATCHER.evaluate(ast);
                if (result != null) {
                    return result;
                }
            } else if (ast.isPower() && ast.get(1) instanceof IAST && ast.get(2) instanceof IInteger && (n = (IInteger)ast.get(2)).isPositive()) {
                IAST powerArg1 = (IAST)ast.get(1);
                if (powerArg1.isSin()) {
                    IExpr x = (IExpr)powerArg1.get(1);
                    return F.Times((IExpr)F.Subtract(F.C1D2, F.Times((IExpr)F.C1D2, (IExpr)F.Cos(F.Times((IExpr)F.C2, x)))), (IExpr)F.Power((IExpr)F.Sin(x), n.subtract(F.C2)));
                }
                if (powerArg1.isCos()) {
                    IExpr x = (IExpr)powerArg1.get(1);
                    return F.Times((IExpr)F.Plus((IExpr)F.C1D2, (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Cos(F.Times((IExpr)F.C2, x)))), (IExpr)F.Power((IExpr)F.Cos(x), n.subtract(F.C2)));
                }
            }
            return this.visitAST(ast);
        }
    }
}

