/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorExpr;

public class TrigToExp
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            throw new WrongNumberOfArguments(functionList, 1, functionList.size() - 1);
        }
        TrigToExpVisitor tteVisitor = new TrigToExpVisitor();
        IExpr result = ((IExpr)functionList.get(1)).accept(tteVisitor);
        if (result != null) {
            return result;
        }
        return (IExpr)functionList.get(1);
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }

    class TrigToExpVisitor
    extends VisitorExpr {
        @Override
        public IExpr visit2(IExpr head, IExpr arg1) {
            IExpr temp = arg1;
            IExpr result = arg1.accept(this);
            if (result != null) {
                temp = result;
            }
            if (head.equals(F.Sin)) {
                return F.Subtract(F.Times(F.C1D2, F.CI, F.Power((IExpr)F.E, F.Times((IExpr)F.CNI, temp))), F.Times(F.C1D2, F.CI, F.Power((IExpr)F.E, F.Times((IExpr)F.CI, temp))));
            }
            if (head.equals(F.Cos)) {
                return F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Power((IExpr)F.E, F.Times((IExpr)F.CNI, temp))), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Power((IExpr)F.E, F.Times((IExpr)F.CI, temp))));
            }
            if (head.equals(F.Tan)) {
                return F.Times(F.CI, F.Subtract(F.Power((IExpr)F.E, F.Times((IExpr)F.CNI, temp)), F.Power((IExpr)F.E, F.Times((IExpr)F.CI, temp))), F.Power((IExpr)F.Plus((IExpr)F.Power((IExpr)F.E, F.Times((IExpr)F.CNI, temp)), (IExpr)F.Power((IExpr)F.E, F.Times((IExpr)F.CI, temp))), F.CN1));
            }
            if (head.equals(F.ArcSin)) {
                return F.Times((IExpr)F.CNI, (IExpr)F.Log(F.Plus((IExpr)F.Sqrt(F.Subtract(F.C1, F.Sqr(temp))), (IExpr)F.Times((IExpr)F.CI, temp))));
            }
            if (head.equals(F.ArcCos)) {
                return F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Pi), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Log(F.Plus((IExpr)F.Sqrt(F.Subtract(F.C1, F.Sqr(temp))), (IExpr)F.Times((IExpr)F.CI, temp)))));
            }
            if (head.equals(F.ArcTan)) {
                return F.Subtract(F.Times(F.C1D2, F.CI, F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CNI, temp)))), F.Times(F.C1D2, F.CI, F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CI, temp)))));
            }
            if (result != null) {
                return F.function(head, result);
            }
            return null;
        }
    }
}

