/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Trunc
extends AbstractFunctionEvaluator {
    static final String[] RULES = new String[]{"Trunc[Pi]=3", "Trunc[E]=2", "Trunc[x_NumberQ*y_] := -Trunc[-x*y] /; SignCmp[x]<0"};

    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            return null;
        }
        if (functionList.get(1) instanceof ISignedNumber) {
            ISignedNumber signedNumber = (ISignedNumber)functionList.get(1);
            if (signedNumber.isNegative()) {
                return signedNumber.ceil();
            }
            return signedNumber.floor();
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public String[] getRules() {
        return RULES;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }
}

