/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.BreakException;
import org.matheclipse.core.eval.exception.ContinueException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class While
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        EvalEngine engine = EvalEngine.get();
        int iterationLimit = engine.getIterationLimit();
        int iterationCounter = 1;
        while (engine.evaluate((IExpr)ast.get(1)).equals(F.True)) {
            try {
                engine.evaluate((IExpr)ast.get(2));
                if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
                IterationLimitExceeded.throwIt(iterationCounter, ast);
            }
            catch (BreakException e) {
                return F.Null;
            }
            catch (ContinueException continueException) {
                // empty catch block
            }
        }
        return F.Null;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

