/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;

public class SQLExpressionMap {
    private static final int MAX_DB_KEY_CHARACTERS = 250;
    private static final String INSERT_STR = "INSERT INTO expr_map (hvalue,lhs,rhs) VALUES (?, ?, ?)";
    private static final String SELECT_STR = "SELECT rhs FROM expr_map WHERE hvalue = ? and lhs = ?";
    private static final String INSERT_LOG_STR = "INSERT INTO log (expr,addr,host,sessionid) VALUES (?, ?, ?, ?)";

    public static void insert(Connection conn, int lhsHash, String lhsString, IExpr rhs) throws SQLException {
        PreparedStatement insertStmt = conn.prepareStatement(INSERT_STR);
        try {
            insertStmt.setInt(1, lhsHash);
            insertStmt.setString(2, lhsString);
            insertStmt.setString(3, rhs.toString());
            insertStmt.executeUpdate();
        }
        finally {
            insertStmt.close();
        }
    }

    public static IExpr select(Connection conn, Parser parser, int lhsHash, String lhsString) throws SQLException, SyntaxError {
        if (lhsString.length() > 250) {
            return null;
        }
        PreparedStatement selectStmt = conn.prepareStatement(SELECT_STR);
        selectStmt.setInt(1, lhsHash);
        selectStmt.setString(2, lhsString);
        ResultSet resultSet = selectStmt.executeQuery();
        try {
            if (resultSet.next()) {
                String rhs = resultSet.getString(1);
                ASTNode parsedAST = parser.parse(rhs);
                IExpr iExpr = AST2Expr.CONST.convert(parsedAST);
                return iExpr;
            }
        }
        finally {
            resultSet.close();
            selectStmt.close();
        }
        return null;
    }

    public static void insertLog(Connection conn, String expr, String addr, String host, String sessionId) throws SQLException {
        PreparedStatement insertStmt = conn.prepareStatement(INSERT_LOG_STR);
        try {
            insertStmt.setString(1, expr);
            insertStmt.setString(2, addr);
            insertStmt.setString(3, host);
            insertStmt.setString(4, sessionId);
            insertStmt.executeUpdate();
        }
        finally {
            insertStmt.close();
        }
    }
}

