/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.AbstractVisitorInt;

public class HashValueVisitor
extends AbstractVisitorInt {
    final int fMaxDepth;
    int currentDepth = 0;

    public HashValueVisitor() {
        this(1);
    }

    public HashValueVisitor(int maxDepth) {
        this.fMaxDepth = maxDepth;
    }

    public void setUp() {
        this.currentDepth = 0;
    }

    @Override
    public int visit(IAST list) {
        try {
            ++this.currentDepth;
            if (this.currentDepth <= this.fMaxDepth) {
                int hash = 0;
                hash = list.size() > 1 ? 31 * ((IExpr)list.get(0)).hashCode() + ((IExpr)list.get(1)).accept(this) + list.size() : (list.size() == 1 ? 17 * ((IExpr)list.get(0)).hashCode() : 41);
                int n = hash;
                return n;
            }
            int n = 31 * list.head().hashCode() + list.size();
            return n;
        }
        finally {
            --this.currentDepth;
        }
    }

    @Override
    public int visit(IComplex element) {
        return element.hashCode();
    }

    @Override
    public int visit(IComplexNum element) {
        return element.hashCode();
    }

    @Override
    public int visit(IFraction element) {
        return element.hashCode();
    }

    @Override
    public int visit(IInteger element) {
        return element.hashCode();
    }

    @Override
    public int visit(INum element) {
        return element.hashCode();
    }

    @Override
    public int visit(IPattern element) {
        return element.hashCode();
    }

    @Override
    public int visit(IStringX element) {
        return element.hashCode();
    }

    @Override
    public int visit(ISymbol element) {
        return element.hashCode();
    }
}

