/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.generic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.List;
import org.matheclipse.generic.interfaces.BiFunction;
import org.matheclipse.generic.interfaces.ISequence;

public class Algorithms {
    public static <T> int count(Collection<T> collection, T value) {
        int counter = 0;
        for (T obj : collection) {
            if (!obj.equals(value)) continue;
            ++counter;
        }
        return counter;
    }

    public static <T> int count(List<T> list, int start, int end, Predicate<T> fn) {
        int counter = 0;
        int i = start;
        while (i < end) {
            if (fn.apply(list.get(i))) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public static <T> int count(List<T> list, int start, int end, T value) {
        int counter = 0;
        int i = start;
        while (i < end) {
            if (list.get(i).equals(value)) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public static <T> int countIf(Collection<T> collection, Predicate<T> predicate) {
        int counter = 0;
        for (T obj : collection) {
            if (!predicate.apply(obj)) continue;
            ++counter;
        }
        return counter;
    }

    public static <T> int countIfNot(Collection<T> collection, Predicate<T> predicate) {
        int counter = 0;
        for (T obj : collection) {
            if (predicate.apply(obj)) continue;
            ++counter;
        }
        return counter;
    }

    public static <T> List<? extends T> drop(List<? extends T> resultList, ISequence sequenceSpecification) {
        int j;
        sequenceSpecification.setListSize(resultList.size());
        int i = j = sequenceSpecification.getStart();
        while (i < sequenceSpecification.getEnd()) {
            resultList.remove(j);
            j += sequenceSpecification.getStep() - 1;
            i += sequenceSpecification.getStep();
        }
        return resultList;
    }

    public static <T> Collection<? super T> foldLeft(T expr, List<T> list, BiFunction<T, T, ? extends T> binaryFunction, Collection<? super T> resultList) {
        return Algorithms.foldLeft(expr, list, 0, list.size(), binaryFunction, resultList);
    }

    public static <T> Collection<? super T> foldLeft(T expr, List<T> list, int start, int end, BiFunction<T, T, ? extends T> binaryFunction, Collection<? super T> resultCollection) {
        if (start < end) {
            T elem = expr;
            resultCollection.add(elem);
            int i = start;
            while (i < end) {
                elem = binaryFunction.apply(elem, list.get(i));
                resultCollection.add(elem);
                ++i;
            }
        }
        return resultCollection;
    }

    public static <T> void forEach(Iterable<? extends T> iterable, Function<T, ? extends T> function) {
        for (T t : iterable) {
            function.apply(t);
        }
    }

    public static <T> void forEach(List<? extends T> list, int start, Function<T, ? extends T> function) {
        Algorithms.forEach(list, start, list.size(), function);
    }

    public static <T> void forEach(List<? extends T> list, int start, int end, Function<T, ? extends T> function) {
        int len = end < list.size() ? end : list.size();
        int i = start;
        while (i < len) {
            function.apply(list.get(i));
            ++i;
        }
    }

    public static <T> T nest(T expr, int n, Function<T, ? extends T> fn) {
        Object temp = expr;
        int i = 0;
        while (i < n) {
            temp = fn.apply(temp);
            ++i;
        }
        return temp;
    }

    public static <T> void nestList(T expr, int n, Function<T, ? extends T> fn, Collection<T> resultList) {
        Object temp = expr;
        resultList.add(temp);
        int i = 0;
        while (i < n) {
            temp = fn.apply(temp);
            resultList.add(temp);
            ++i;
        }
    }

    public static <T> Collection<? super T> take(List<? extends T> list, Collection<? super T> resultCollection, ISequence sequenceSpecification) {
        sequenceSpecification.setListSize(list.size());
        int i = sequenceSpecification.getStart();
        while (i < sequenceSpecification.getEnd()) {
            resultCollection.add(list.get(i));
            i += sequenceSpecification.getStep();
        }
        return resultCollection;
    }

    public static <T> Collection<T> transform(Iterable<T> iterable, Function<T, ? extends T> function, Collection<T> resultCollection) {
        for (T t : iterable) {
            resultCollection.add(function.apply(t));
        }
        return resultCollection;
    }

    public static <T> Collection<T> transform(List<T> list, int start, Function<T, ? extends T> function, Collection<T> resultCollection) {
        return Algorithms.transform(list, start, list.size(), function, resultCollection);
    }

    public static <T> Collection<T> transform(List<T> list, int start, int end, Function<T, ? extends T> function, Collection<T> resultCollection) {
        int len = end < list.size() ? end : list.size();
        int i = start;
        while (i < len) {
            resultCollection.add(function.apply(list.get(i)));
            ++i;
        }
        return resultCollection;
    }
}

