/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.generic;

import org.matheclipse.generic.AbstractSequence;
import org.matheclipse.generic.WrongSequenceException;

public class ListSizeSequence
extends AbstractSequence {
    protected final int fHeadOffset;
    protected int fListSize;

    public ListSizeSequence() {
        this(0);
    }

    public ListSizeSequence(int startOffset) {
        this(startOffset, Integer.MIN_VALUE, 1, 0);
    }

    public ListSizeSequence(int startOffset, int endOffset) {
        this(startOffset, endOffset, 1, 0);
    }

    public ListSizeSequence(int startOffset, int endOffset, int step) {
        this(startOffset, endOffset, step, 0);
    }

    public ListSizeSequence(int startOffset, int endOffset, int step, int headOffset) {
        super(startOffset, endOffset, step);
        if (step < 0) {
            throw new WrongSequenceException("Negative step:" + step);
        }
        this.fHeadOffset = headOffset;
        this.fListSize = Integer.MIN_VALUE;
    }

    @Override
    public void setListSize(int size) {
        this.fListSize = size;
    }

    @Override
    public int getStart() {
        if (this.fEndOffset < 0) {
            int tailOffset;
            if (this.fStartOffset < 0 && (tailOffset = this.fListSize + this.fStartOffset) >= 0) {
                return tailOffset;
            }
            return this.fHeadOffset;
        }
        if (this.fStartOffset >= 0) {
            return this.fStartOffset;
        }
        throw new WrongSequenceException("Wrong start offset:" + this.fStartOffset);
    }

    @Override
    public int getEnd() {
        if (this.fEndOffset < 0) {
            if (this.fStartOffset < 0) {
                return this.fListSize;
            }
            if (this.fStartOffset + this.fHeadOffset <= this.fListSize) {
                return this.fStartOffset + this.fHeadOffset;
            }
            throw new WrongSequenceException("Wrong end offset:" + this.fEndOffset);
        }
        return this.fEndOffset + 1;
    }
}

