/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.generic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.matheclipse.generic.interfaces.Aggregator;
import org.matheclipse.generic.interfaces.BiFunction;
import org.matheclipse.generic.interfaces.BiPredicate;
import org.matheclipse.generic.interfaces.IUnaryIndexFunction;

public class Range<E, L extends List<E>>
implements Iterable<E> {
    final L fList;
    final int fStart;
    final int fEnd;

    public Range(L list) {
        this(list, 0, list.size());
    }

    public Range(L list, int start) {
        this(list, start, list.size());
    }

    public Range(L list, int start, int end) {
        this.fList = list;
        this.fStart = start;
        this.fEnd = end;
        if (this.fStart < 0 || this.fStart > this.fList.size()) {
            throw new IndexOutOfBoundsException("Start index not allowed for the given list");
        }
        if (this.fEnd < 0 || this.fEnd > this.fList.size()) {
            throw new IndexOutOfBoundsException("End index not allowed for the given list");
        }
        if (this.fStart > this.fEnd) {
            throw new IndexOutOfBoundsException("Start index greater than end index");
        }
    }

    public E aggregate(Aggregator<E> aggregator) {
        return aggregator.aggregate(this);
    }

    public boolean all(Predicate<E> predicate) {
        int i = this.fStart;
        while (i < this.fEnd) {
            if (!predicate.apply(this.fList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean all(Predicate<E>[] predicates) {
        int i = this.fStart;
        while (i < this.fEnd) {
            int j = 0;
            while (j < predicates.length) {
                if (!predicates[i].apply(this.fList.get(i))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean any(Predicate<E> predicate) {
        int i = this.fStart;
        while (i < this.fEnd) {
            if (predicate.apply(this.fList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean any(Predicate<E>[] predicates) {
        int i = this.fStart;
        while (i < this.fEnd) {
            int j = 0;
            while (j < predicates.length) {
                if (predicates[i].apply(this.fList.get(i))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean compareAdjacent(BiPredicate<E> predicate) {
        if (this.fStart >= this.fEnd - 1) {
            return false;
        }
        Object elem = this.fList.get(this.fStart);
        int i = this.fStart + 1;
        while (i < this.fEnd) {
            if (!predicate.apply(elem, this.fList.get(i))) {
                return false;
            }
            elem = this.fList.get(i);
            ++i;
        }
        return true;
    }

    public L complement(L result, Range<E, L> secondRange) {
        if (this.size() == 0 && secondRange.size() == 0) {
            return result;
        }
        HashSet set1 = Sets.newHashSet((Iterable)this);
        HashSet set2 = Sets.newHashSet(secondRange);
        Sets.SetView set3 = Sets.difference((Set)set1, (Set)set2);
        for (Object e : set3) {
            result.add(e);
        }
        return result;
    }

    public boolean contains(E o) {
        return this.indexOf(o) >= 0;
    }

    public boolean containsAll(Collection<? extends E> c) {
        Iterator<E> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    public int count(Object value) {
        int counter = 0;
        int i = this.fStart;
        while (i < this.fEnd) {
            if (value.equals(this.fList.get(i))) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public int countIf(Predicate<E> predicate) {
        int counter = 0;
        int i = this.fStart;
        while (i < this.fEnd) {
            if (predicate.apply(this.fList.get(i))) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public int findAdjacent(Predicate<E> predicate) {
        return this.findAdjacent(predicate, this.fStart);
    }

    public int findAdjacent(Predicate<E> predicate, int start) {
        int i = start;
        while (i < this.fEnd - 1) {
            if (predicate.apply(this.fList.get(i)) && predicate.apply(this.fList.get(i + 1))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public L difference(L result, Range<E, L> secondList) {
        if (this.size() == 0 && secondList.size() == 0) {
            return result;
        }
        HashSet set1 = Sets.newHashSet((Iterable)this);
        HashSet set2 = Sets.newHashSet(secondList);
        Sets.SetView set3 = Sets.difference((Set)set1, (Set)set2);
        for (Object e : set3) {
            result.add(e);
        }
        return result;
    }

    public int findAdjacent(Object match) {
        return this.findAdjacent(match, this.fStart);
    }

    public int findAdjacent(Object match, int start) {
        if (match == null) {
            int i = this.fStart;
            while (i < this.fEnd - 1) {
                if (this.fList.get(i) == null && this.fList.get(i + 1) == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = this.fStart;
            while (i < this.fEnd - 1) {
                if (match.equals(this.fList.get(i)) && match.equals(this.fList.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public E fold(BiFunction<E, E, ? extends E> function) {
        if (this.fStart >= this.fEnd) {
            return null;
        }
        Object value = this.fList.get(this.fStart);
        if (this.fStart == this.fEnd) {
            return function.apply(value, null);
        }
        int i = this.fStart + 1;
        while (i < this.fEnd) {
            value = function.apply(value, this.fList.get(i));
            ++i;
        }
        return value;
    }

    public E fold(BiFunction<E, E, ? extends E> function, E startValue) {
        E value = startValue;
        int i = this.fStart;
        while (i < this.fEnd) {
            value = function.apply(value, this.fList.get(i));
            ++i;
        }
        return value;
    }

    public E forEach(Function<E, ? extends E> function) {
        Object value = null;
        int i = this.fStart;
        while (i < this.fEnd) {
            value = function.apply(this.fList.get(i));
            ++i;
        }
        return (E)value;
    }

    public final E get(int index) {
        return this.fList.get(index);
    }

    public final int getEnd() {
        return this.fEnd;
    }

    public final L getList() {
        return this.fList;
    }

    public final int getStart() {
        return this.fStart;
    }

    public int indexOf(Predicate<E> predicate) {
        return this.indexOf((E)predicate, this.fStart);
    }

    public int indexOf(Predicate<E> predicate, int start) {
        int i = start;
        while (i < this.fEnd) {
            if (predicate.apply(this.fList.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(E match) {
        return this.indexOf(match, this.fStart);
    }

    public int indexOf(E match, int start) {
        if (match == null) {
            int i = start;
            while (i < this.fEnd) {
                if (this.fList.get(i) == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = start;
            while (i < this.fEnd) {
                if (match.equals(this.fList.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public L intersection(L result, Range<E, L> secondList) {
        if (this.size() == 0 && secondList.size() == 0) {
            return result;
        }
        HashSet set1 = Sets.newHashSet((Iterable)this);
        HashSet set2 = Sets.newHashSet(secondList);
        Sets.SetView set3 = Sets.intersection((Set)set1, (Set)set2);
        for (Object e : set3) {
            result.add(e);
        }
        return result;
    }

    public int lastIndexOf(Predicate<E> predicate) {
        int i = this.fEnd - 1;
        while (i >= this.fStart) {
            if (predicate.apply(this.fList.get(i))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int lastIndexOf(Object match) {
        if (match == null) {
            int i = this.fEnd - 1;
            while (i >= this.fStart) {
                if (this.fList.get(i) == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = this.fEnd - 1;
            while (i >= this.fStart) {
                if (match.equals(this.fList.get(i))) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public boolean map(L list, BiFunction<E, E, E> function) {
        if (this.fStart >= this.fEnd) {
            return false;
        }
        boolean evaled = false;
        Object element = this.fList.get(this.fStart);
        int i = this.fStart + 1;
        while (i < this.fEnd) {
            E result = function.apply(element, this.fList.get(i));
            if (result == null) {
                list.add(element);
                element = this.fList.get(i);
            } else {
                evaled = true;
                element = result;
            }
            ++i;
        }
        list.add(element);
        return evaled;
    }

    public L map(L list, Function<E, E> function) {
        int i = this.fStart;
        while (i < this.fEnd) {
            list.add((Object)function.apply(this.fList.get(i)));
            ++i;
        }
        return list;
    }

    public L map(L list, IUnaryIndexFunction<E, E> function) {
        int i = this.fStart;
        while (i < this.fEnd) {
            list.add(function.apply(i, this.fList.get(i)));
            ++i;
        }
        return list;
    }

    public L mapLeft(L list, BiFunction<E, E, E> binaryFunction, E leftArg) {
        int i = this.fStart;
        while (i < this.fEnd) {
            list.add(binaryFunction.apply(leftArg, this.fList.get(i)));
            ++i;
        }
        return list;
    }

    public L mapRight(L list, BiFunction<E, E, E> binaryFunction, E rightArg) {
        int i = this.fStart;
        while (i < this.fEnd) {
            list.add(binaryFunction.apply(this.fList.get(i), rightArg));
            ++i;
        }
        return list;
    }

    public E max(Comparator<? super E> comp) {
        Object value = this.fList.get(this.fStart);
        int i = this.fStart + 1;
        while (i < this.fEnd) {
            if (comp.compare(this.fList.get(i), value) > 0) {
                value = this.fList.get(i);
            }
            ++i;
        }
        return value;
    }

    public E min(Comparator<? super E> comp) {
        Object value = this.fList.get(this.fStart);
        int i = this.fStart + 1;
        while (i < this.fEnd) {
            if (comp.compare(this.fList.get(i), value) < 0) {
                value = this.fList.get(i);
            }
            ++i;
        }
        return value;
    }

    public L removeAll(L list, Predicate<E> predicate) {
        int i = this.fStart;
        while (i < this.fEnd) {
            if (!predicate.apply(this.fList.get(i))) {
                list.add(this.fList.get(i));
            }
            ++i;
        }
        return list;
    }

    public L replaceAll(L list, Function<E, ? extends E> function) {
        int i = this.fStart;
        while (i < this.fEnd) {
            list.add((Object)function.apply(this.fList.get(i)));
            ++i;
        }
        return list;
    }

    public L reverse(L list) {
        int i = this.fEnd - 1;
        while (i >= this.fStart) {
            list.add(this.fList.get(i));
            --i;
        }
        return list;
    }

    public L rotateLeft(L list, int n) {
        int i = this.fStart + n;
        while (i < this.fEnd) {
            list.add(this.fList.get(i));
            ++i;
        }
        if (n <= this.size()) {
            i = this.fStart;
            while (i < this.fStart + n) {
                list.add(this.fList.get(i));
                ++i;
            }
        }
        return list;
    }

    public L rotateRight(L list, int n) {
        if (n <= this.size()) {
            int i = this.fEnd - n;
            while (i < this.fEnd) {
                list.add(this.fList.get(i));
                ++i;
            }
            i = this.fStart;
            while (i < this.fEnd - n) {
                list.add(this.fList.get(i));
                ++i;
            }
        }
        return list;
    }

    public L select(L list, Predicate<E> predicate) {
        int i = this.fStart;
        while (i < this.fEnd) {
            if (predicate.apply(this.fList.get(i))) {
                list.add(this.fList.get(i));
            }
            ++i;
        }
        return list;
    }

    public L select(L list, Predicate<E> predicate, int maxMatches) {
        int count = 0;
        if (count == maxMatches) {
            return list;
        }
        int i = this.fStart;
        while (i < this.fEnd) {
            if (predicate.apply(this.fList.get(i))) {
                if (++count == maxMatches) {
                    list.add(this.fList.get(i));
                    break;
                }
                list.add(this.fList.get(i));
            }
            ++i;
        }
        return list;
    }

    public int size() {
        return this.fEnd - this.fStart;
    }

    public L sort(Comparator<E> comparator) {
        Object[] a = this.fList.toArray();
        Arrays.sort(a, this.fStart, this.fEnd, comparator);
        int j = this.fStart;
        while (j < this.fEnd) {
            this.fList.set(j, (Object)a[j]);
            ++j;
        }
        return this.fList;
    }

    public List<E> toList(List<E> list) {
        int i = this.fStart;
        while (i < this.fEnd) {
            list.add(this.fList.get(i));
            ++i;
        }
        return list;
    }

    public L union(L result, Range<E, L> secondList) {
        if (this.size() == 0 && secondList.size() == 0) {
            return result;
        }
        HashSet set1 = Sets.newHashSet((Iterable)this);
        HashSet set2 = Sets.newHashSet(secondList);
        Sets.SetView set3 = Sets.union((Set)set1, (Set)set2);
        for (Object e : set3) {
            result.add(e);
        }
        return result;
    }

    public E[] toArray(E[] array) {
        int j = this.fStart;
        int i = 0;
        while (i < array.length) {
            array[i] = this.fList.get(j++);
            if (j >= array.length) break;
            ++i;
        }
        return array;
    }

    @Override
    public Iterator<E> iterator() {
        return new RangeIterator(this);
    }

    class RangeIterator
    implements Iterator<E> {
        private Range<E, L> fRange;
        private int fCurrrent;

        public RangeIterator(Range<E, L> range2) {
            this.fRange = range2;
            this.fCurrrent = this.fRange.fStart;
        }

        @Override
        public boolean hasNext() {
            return this.fCurrrent < this.fRange.fEnd;
        }

        @Override
        public E next() {
            return this.fRange.get(this.fCurrrent++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

