/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.generic.combinatoric;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.matheclipse.core.generic.util.INestedListElement;
import org.matheclipse.generic.nested.INestedList;

class CartesianProductIterator<T extends INestedListElement, L extends List<T> & INestedListElement>
implements Iterator<L> {
    final List<L> comps;
    final List<Iterator<T>> compit;
    L current;
    boolean empty;
    private final INestedList<T, L> fCopier;

    public CartesianProductIterator(List<L> comps, L emptyResultList, INestedList<T, L> copier) {
        if (comps == null) {
            throw new IllegalArgumentException("null comps not allowed");
        }
        this.fCopier = copier;
        this.comps = comps;
        this.current = emptyResultList;
        this.compit = new ArrayList<Iterator<T>>(comps.size());
        this.empty = false;
        for (List ci : comps) {
            Iterator it = ci.iterator();
            if (!it.hasNext()) {
                this.empty = true;
                this.current.clear();
                break;
            }
            this.current.add((INestedListElement)((INestedListElement)it.next()));
            this.compit.add(it);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.empty;
    }

    @Override
    public synchronized L next() {
        Iterator<Object> iter;
        if (this.empty) {
            throw new RuntimeException("invalid call of next()");
        }
        L res = this.fCopier.clone(this.current);
        int i = this.compit.size() - 1;
        while (i >= 0) {
            Iterator<T> iter2 = this.compit.get(i);
            if (iter2.hasNext()) break;
            --i;
        }
        if (i < 0) {
            this.empty = true;
            return res;
        }
        int j = i + 1;
        while (j < this.compit.size()) {
            iter = ((List)this.comps.get(j)).iterator();
            this.compit.set(j, iter);
            ++j;
        }
        j = i;
        while (j < this.compit.size()) {
            iter = this.compit.get(j);
            INestedListElement el = (INestedListElement)iter.next();
            this.current.set(j + 1, (INestedListElement)el);
            ++j;
        }
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove tuples");
    }
}

