/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.generic.interfaces;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Pair<A extends Comparable<? super A>, B extends Comparable<? super B>>
implements Comparable<Pair<A, B>>,
Serializable {
    private static final long serialVersionUID = 1322589550168140645L;
    private A m_first;
    private B m_second;

    public Pair() {
    }

    public Pair(A p_first, B p_second) {
        this.m_first = p_first;
        this.m_second = p_second;
    }

    public A getFirst() {
        return this.m_first;
    }

    public void setFirst(A p_first) {
        this.m_first = p_first;
    }

    public B getSecond() {
        return this.m_second;
    }

    public void setSecond(B p_second) {
        this.m_second = p_second;
    }

    public int hashCode() {
        int hc = 0;
        if (this.m_first != null) {
            hc += this.m_first.hashCode();
        }
        if (this.m_second != null) {
            hc *= 31;
            hc += this.m_second.hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair other = (Pair)obj;
            return this.m_first.equals(other.getFirst()) && this.m_second.equals(other.getSecond());
        }
        return false;
    }

    @Override
    public int compareTo(Pair<A, B> p_pair) {
        try {
            int result = this.m_first.compareTo(p_pair.getFirst());
            if (result == 0) {
                result = this.m_second.compareTo(p_pair.getSecond());
            }
            return result;
        }
        catch (ClassCastException exc) {
            return 0;
        }
    }

    protected List<String> getStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.valueOf(this.m_first));
        result.add(String.valueOf(this.m_second));
        return result;
    }

    public String toString() {
        return "(" + this.m_first.toString() + ", " + this.m_second.toString() + ")";
    }
}

